$(document).ready(function () {
    CargarDatos();
});


function CargarDatos(){

    $.datepicker.regional['es'] = {
        closeText: 'Cerrar',
        prevText: '< Ant',
        nextText: 'Sig >',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
        dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
        dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
        weekHeader: 'Sm',
        dateFormat: 'dd/mm/yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ''
    };
    $.datepicker.setDefaults($.datepicker.regional['es']);

    $("#datepickerInicio").datepicker();
    $("#datepickerFin").datepicker();

}


function Cargar() {

    var data = [];
    var perfil = 0;
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/contador",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
            perfil = result.perfil;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });

    var item = perfil < 3 ? "Bfrtip" : "frtip";
    CargarTabla(data, item);
}


function CargarTabla(dataSet, dom) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: false,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_factura" },
            { mData: "nit" },
            { mData: "nombre" },
            { mData: "fecha" },
            { mData: "total", "className": "text-right" },
            { mData: "estatus" },
            //{ mData: "confirmacion" },
            { mData: "usuario" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [7],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Descargar(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Descargar"><span class="glyphicon glyphicon-save"></span></a>';
                    else
                        return '';
                }
            },
            {
                "aTargets": [8],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Imprimir(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Imprimir"><span class="glyphicon glyphicon-print"></span></a>';
                    else
                        return '';
                }
            },
            {
                "aTargets": [9],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Cambiar(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nit) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.fecha) + "&#39;" + "," + "&#39;" + encodeURI(full.total) + "&#39;" + "," + full.estado + ');" class="btn btn-danger btn-md" style="display:' + '" title="Anular"><span class="glyphicon glyphicon-remove"></span></a>';
                    else
                        return '';
                }
            }
        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        },
        dom: dom,
        buttons:
            [
                'pdfHtml5',
                'excelHtml5'
                /*
                'print',
                'copyHtml5',
                'csvHtml5'
                */
            ]
    });

    /*
    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
    */
}


function Descargar(id) {

    var error = "";
    var base64 = "";
    var nombre = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/factura/download",
        data: {
            id: id
        },
        success: function (result) {
            error = result.error;
            base64 = result.base64;
            nombre = result.nombre;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    DescargarArchivo(base64, nombre, "application/octet-stream");
}


function DescargarArchivo(base64, nombre, mime) {

    var ua = window.navigator.userAgent;
    var msie = ua.indexOf('MSIE ');
    var trident = ua.indexOf('Trident/');
    var edge = ua.indexOf('Edge/');
    var esIE = false;


    var binary_string = window.atob(base64);
    //var binary_string = window.atob(str64);
    var len = binary_string.length;
    var bytes = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
        bytes[i] = binary_string.charCodeAt(i);
    }

    var nuevoArray = bytes.buffer;
    var blob = new Blob([nuevoArray], { type: mime });

    if (msie > 0 || trident > 0 || edge > 0) {
        window.navigator.msSaveOrOpenBlob(blob, nombre);
        return;
    }

    var a = document.createElement("a");
    document.body.appendChild(a);
    a.style = "display: block";

    url = window.URL.createObjectURL(blob);
    a.href = url;
    a.download = nombre;
    a.click();
    window.URL.revokeObjectURL(url);
}


function Imprimir(id) {

    var error = "";
    var base64 = "";
    var nombre = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/factura/download",
        data: {
            id: id
        },
        success: function (result) {
            error = result.error;
            base64 = result.base64;
            nombre = result.nombre;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    printJS({ printable: base64, type: 'pdf', base64: true });
}


function Cambiar(id, nit, nombre, fecha, total, index) {

    var html = `¿Esta seguro de anular la siguiente factura con lo siguientes datos: ?
                <br/>
                <br/>
                <table class="table table-striped">
                <thead>
                </thead>
                <tbody>
                <tr>
                <td>FACTURA</td>
                <td>${decodeURI(id)}</td>
                </tr>
                <tr>
                <td>NIT </td>
                <td>${decodeURI(nit)}</td>
                </tr>
                <tr>
                <td>NOMBRE </td>
                <td>${decodeURI(nombre)}</td>
                </tr>
                <tr>
                <td>FECHA </td>
                <td>${decodeURI(fecha)}</td>
                </tr>
                <tr>
                <td>TOTAL </td>
                <td>${decodeURI(total)}</td>
                </tr>
                </tbody>
                </table>
                `;

    $("#hfId").val(decodeURI(id));
    $("#hfIndex").val(index);

    $("#spTextoBorrar").html(html);
    $('#modalBorrar').modal('show');
}


function Anular() {

    var id = $("#hfId").val();
    var rowIndex = $("#hfIndex").val();
    var error = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/factura/cancel",
        data: {
            id: id
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("Factura anulada exitosamente");
    $('#modalBorrar').modal('hide');
}
