$(document).ready(function () {

    Cargar();

    $("#btnNuevo").click(function (e) {
        MostrarNuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if (event.keyCode == 74 && event.ctrlKey) {
            event.preventDefault();
        }
    });

    $("#btnBuscarProductos").click(function (e) {
        MostrarProductos();
        return true;
    });

    $("#btnLimpiar").click(function (e) {
        Limpiar();
        return true;
    });

    $("#btnAlmacenarCatalogo").click(function (e) {
        AlmacenarCatalogo();
        return true;
    });



});

function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}


var productos = [];
var asociados = [];
function CargarProductos() {

    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/producto",
        data: {
        },
        success: function (result) {
            error = result.error;
            productos = result.mensaje;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    CargarTablaProductos(productos);
}


function CargarTablaProductos(dataSet) {

    var t = $('#tbProductos').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_producto" },
            { mData: "envase" },
            { mData: "nombre" },
        ],
        aoColumnDefs: [
            {
                "title": "Marcar",
                "aTargets": [3],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Agregar(' + full.id_producto + ',' + meta.row + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.precio) + "&#39;" + "," + full.existencia + ');" class="btn btn-primary btn-md" style="display:' + '" title="Agregar"><span class="glyphicon glyphicon-plus"></span></a>';
                }
            }
        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });
}


function Cargar() {

    var data = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/catalogo",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });

    CargarTablaAsociados([]);
    CargarTabla(data);
    CargarProductos();
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_catalogo" },
            { mData: "nombre" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [2],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + "&#39;" + encodeURI(full.id_envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Editar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [3],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:BorrarCatalogo(' + "&#39;" + encodeURI(full.id_catalogo) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Borrar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [4],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Seleccionar(' + "&#39;" + encodeURI(full.id_catalogo) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-danger btn-md" style="display:' + '" title="Seleccionar"><span class="glyphicon glyphicon-barcode"></span></a>';
                }
            },
            {
                "aTargets": [5],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Descargar(' + "&#39;" + encodeURI(full.id_catalogo) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Descargar"><span class="glyphicon glyphicon-barcode"></span></a>';
                }
            }

        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}



function MostrarNuevo() {

    $("#hfId").val("");
    $("#txtNit").val("");
    $("#txtNombre").val("");
    $("#txtTelefono").val("");
    $("#txtEmail").val("");
    $("#txtDireccion").val("");

    $("#spTitulo").text("Nuevo catálogo");
    $('#nuevoCliente').modal('show');
}



function Almacenar() {

    var id = $("#hfId").val() == "" ? 0 : $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {

    var nombre = $("#txtNombre").val().trim();
    var error = "";

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/catalogo",
        data: {
            nombre: nombre
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}


function Editar(id, nombre) {

    $("#hfId").val(id);
    $("#txtNombre").val(decodeURI(nombre));

    $("#spTitulo").text("Editar catálogo " + decodeURI(nombre));
    $('#nuevoCliente').modal('show');
}


function Actualizar() {

    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();
    var error = "";

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    $.ajax({
        async: false,
        type: "PUT",
        url: "/catalogo",
        data: {
            id: id,
            nombre: nombre
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}


function BorrarCatalogo(id, nombre) {

    $("#hfId").val(decodeURI(id));
    $("#spTextoBorrar").html("¿Esta seguro de eliminar el catálogo de " + decodeURI(nombre) + "?");
    $('#modalBorrar').modal('show');
}


function Eliminar() {

    var id = $("#hfId").val();

    $.ajax({
        async: false,
        type: "DELETE",
        url: "/catalogo",
        data: {
            id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();
    Limpiar();

    MensajeExitoso("registro eliminado");
    $('#modalBorrar').modal('hide');
}


function MostrarProductos() {

    var id = $("#hfId").val();

    if (id == "") {
        MensajeError("Seleccione catálogo");
        return;
    }

    $('#buscarProductos').modal('show');
}


function Limpiar() {

    $("#hfId").val("");
    $("#spCatalogo").text("Seleccione Catálogo");

    asociados = [];
    CargarTablaAsociados([]);
}

var items = [];

function Seleccionar(id, nombre) {

    $("#hfId").val(id);
    $("#spCatalogo").text("Catálogo: " + decodeURI(nombre));

    $.ajax({
        async: false,
        type: "GET",
        url: "/catalogo-producto",
        data: {
            id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
            asociados = result.mensaje;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    CargarTablaAsociados(asociados);
}


function CargarTablaAsociados(dataSet) {

    var t = $('#tbAsociados').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "numero" },
            { mData: "envase" },
            { mData: "nombre" },
        ],
        aoColumnDefs: [
            {
                "title": "Marcar",
                "aTargets": [3],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + full.numero + ');" class="btn btn-primary btn-md" style="display:' + '" title="Borrar"><span class="glyphicon glyphicon-trash"></span></a>';
                }
            }
        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });
}


function Agregar(id, roxIndex, envase, producto, precio, existencia) {

    for (var i = 0; i < asociados.length; i++) {

        var dto = asociados[i];

        if (dto.id == id) {
            MensajeError("El producto ya fué seleccionado");
            return;
        }
    }

    var index = asociados.length;
    var dto = { numero: index + 1, id: id, envase: decodeURI(envase), nombre: decodeURI(producto) };
    asociados.push(dto);

    for (var i = 0; i < productos.length; i++) {
        var pas = productos[i];

        if (id == pas.id_producto) {
            pas.existencia = pas.existencia - 1;
            break;
        }
    }

    CargarTablaAsociados(asociados);
}


function Borrar(index) {

    for (var i = 0; i < asociados.length; i++) {

        var dto = asociados[i];

        if (dto.numero == index) {
            asociados.splice(i, 1);
        }
    }

    for (var i = 0; i < asociados.length; i++) {
        var dto = asociados[i];
        dto.numero = i + 1;
    }


    if (asociados.length > 0)
        CargarTablaAsociados(asociados);
    else
        CargarTablaAsociados([]);

}


function AlmacenarCatalogo() {

    var error = "";
    var id = $("#hfId").val();

    if (id == "") {
        MensajeError("Seleccione Catálogo");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/catalogo-producto",
        data: {
            id: id,
            productos: asociados
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    MensajeExitoso("Registro almacenado exitosamente");
    Limpiar();
}


function replaceNewLines(inputString) {
    // Reemplazar todas las ocurrencias de \r\n por ""
    return inputString.replace(/\r\n/g, "");
}


async function Descargar(id, catalogo) {

    try {
        $("#divLoading").show();

        var parametros = { id: id, catalogo: catalogo };
        var info = await postProcess("/catalogo/download", parametros);

        if (info.error != "") {
            MensajeError(info.error);
            return;
        }

        await DescargarPDF(info.html, info.nombre);
        //DescargarArchivo(info.base64, info.nombre, "application/octet-stream");

    } catch (err) {
        MensajeError(err.message);
    } finally {
        $("#divLoading").hide();
    }

}


function DescargarArchivo(base64, nombre, mime) {

    var ua = window.navigator.userAgent;
    var msie = ua.indexOf('MSIE ');
    var trident = ua.indexOf('Trident/');
    var edge = ua.indexOf('Edge/');
    var esIE = false;


    var binary_string = window.atob(base64);
    //var binary_string = window.atob(str64);
    var len = binary_string.length;
    var bytes = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
        bytes[i] = binary_string.charCodeAt(i);
    }

    var nuevoArray = bytes.buffer;
    var blob = new Blob([nuevoArray], { type: mime });

    if (msie > 0 || trident > 0 || edge > 0) {
        window.navigator.msSaveOrOpenBlob(blob, nombre);
        return;
    }

    var a = document.createElement("a");
    document.body.appendChild(a);
    a.style = "display: block";

    url = window.URL.createObjectURL(blob);
    a.href = url;
    a.download = nombre;
    a.click();
    window.URL.revokeObjectURL(url);
}


async function DescargarPDF2(html, nombre) {

    var pdf = new jsPDF('p', 'pt', 'letter');

    margins = {
        top: 10,
        //bottom: 60,
        left: 10,
        width: 600
    };

    await pdf.fromHTML(
        html,
        margins.left, // x coord
        margins.top, { // y coord
        'width': margins.width,
    },

        function (dispose) {
            pdf.save(nombre);
        }, margins,

    );

}


async function DescargarPDF(html, nombre) {

    const { jsPDF } = window.jspdf;
    const doc = new jsPDF({ format: 'letter' });

    await doc.html(html, {
        callback: function (doc) {
            doc.save(nombre);
        },
        x: 10,
        y: 10,
        html2canvas: { scale: 0.17 }
    });
}