module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("factura", {
        id_factura: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        id_cliente: { type: Sequelize.INTEGER, references: { model: 'cliente', key: 'id_cliente', } },
        total: { type: Sequelize.DECIMAL(10, 2) },
        estado: { type: Sequelize.INTEGER },
        autorizacion: { type: Sequelize.STRING, max: 200 },
        tipo: { type: Sequelize.INTEGER },
        control: { type: Sequelize.STRING, max: 10 },
        id_usuario: { type: Sequelize.INTEGER, references: { model: 'usuario', key: 'id_usuario', } },
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'factura'
    });

    return modelo;
};