const BUCKET_URL = "/upload-stream-chunk"; // tu endpoint real

const CHUNK_SIZE = 50 * 1024 * 1024; // 50 MB
let xhr = null;


$("#uploadForm").on("submit", async function (e) {
    e.preventDefault();

    const file = $("#fileInput")[0].files[0];
    if (!file) return alert("Selecciona un archivo primero.");

    const progressBar = $("#progressBar");
    const progressContainer = $(".progress");
    const logBox = $("#logBox");
    const statusMessage = $("#statusMessage");
    const uploadBtn = $("#uploadBtn");
    const uploadSpinner = $("#uploadSpinner");
    const uploadText = $("#uploadText");

    // === 🔄 UI Inicial ===
    progressContainer.show();
    progressBar
        .css("width", "0%")
        .text("0%")
        .removeClass("bg-success bg-danger bg-warning")
        .addClass("bg-primary");
    logBox.html("");
    statusMessage.text("📤 Preparando carga...");
    uploadBtn.prop("disabled", true);
    uploadSpinner.removeClass("d-none");
    uploadText.text("Subiendo...");

    const totalChunks = Math.ceil(file.size / CHUNK_SIZE);
    const fileId = file.name; // nombre original completo, con extensión
    const extension = "." + file.name.split(".").pop().toLowerCase(); // solo para validación
    const ambiente = "desa";
    const subfolder = "final";

    const startTime = Date.now();
    let totalSent = 0;

    try {
        for (let i = 0; i < totalChunks; i++) {
            const start = i * CHUNK_SIZE;
            const end = Math.min(file.size, start + CHUNK_SIZE);
            const chunk = file.slice(start, end);
            const chunkSizeMB = ((end - start) / 1024 / 1024).toFixed(2);

            logBox.append(`🚀 Enviando chunk ${i + 1}/${totalChunks} (${chunkSizeMB} MB)...\n`);
            logBox.scrollTop(logBox[0].scrollHeight);

            xhr = new XMLHttpRequest();

            const queryParams = new URLSearchParams({
                ambiente,
                subfolder,
                fileId,
                chunkIndex: i,
                totalChunks,
                extension,
            }).toString();

            xhr.open("POST", `${BUCKET_URL}?${queryParams}`, true);


            xhr.upload.onprogress = function (e) {
                if (e.lengthComputable) {
                    totalSent = i * CHUNK_SIZE + e.loaded;
                    const percent = Math.min(Math.round((totalSent / file.size) * 100), 100);
                    const mbSent = (totalSent / 1024 / 1024).toFixed(2);
                    const mbTotal = (file.size / 1024 / 1024).toFixed(2);

                    progressBar.css("width", percent + "%").text(percent + "%");

                    if (percent < 100) {
                        progressBar.removeClass("bg-warning bg-success").addClass("bg-primary");
                    } else {
                        progressBar.removeClass("bg-primary").addClass("bg-warning");
                        statusMessage.text("📦 Carga completa, fusionando en servidor...");
                    }

                    // 🪵 Mueve el log después de actualizar la UI
                    if (i === totalChunks - 1) {
                        setTimeout(() => {
                            logBox.append(`📦 ${mbSent}/${mbTotal} MB enviados...\n`);
                            logBox.scrollTop(logBox[0].scrollHeight);
                        }, 0);
                    }
                }
            };

            await new Promise((resolve, reject) => {
                xhr.onload = () => {
                    if (xhr.status >= 200 && xhr.status < 300) {
                        try {
                            const data = JSON.parse(xhr.responseText);
                            logBox.append(`✅ Chunk ${i + 1} subido: ${data.message || "OK"}\n`);
                            logBox.scrollTop(logBox[0].scrollHeight);
                            resolve();
                        } catch {
                            logBox.append("⚠️ Servidor respondió sin JSON (posible error proxy)\n");
                            reject("Respuesta no válida");
                        }
                    } else {
                        reject(`Error ${xhr.status}: ${xhr.statusText}`);
                    }
                };
                xhr.onerror = () => reject("⚠️ Error de red o CORS bloqueado");
                xhr.send(chunk);
            });
        }

        // ✅ Finalizado
        const totalTime = ((Date.now() - startTime) / 1000).toFixed(1);
        progressBar.removeClass("bg-warning").addClass("bg-success");
        statusMessage.text(`✅ Archivo completo en ${totalTime}s`);
        logBox.append("\n✅ Archivo fusionado correctamente en el bucket\n");
        logBox.scrollTop(logBox[0].scrollHeight);
    } catch (err) {
        console.error(err);
        progressBar.removeClass("bg-primary bg-warning").addClass("bg-danger");
        statusMessage.text("❌ Error: " + err);
        logBox.append(`❌ ${err}\n`);
        logBox.scrollTop(logBox[0].scrollHeight);
    } finally {
        uploadBtn.prop("disabled", false);
        uploadSpinner.addClass("d-none");
        uploadText.text("Subir");
    }
});


// === 🧹 Botón limpiar / cancelar ===
$("#clearBtn").on("click", function () {
    if (xhr && xhr.readyState !== 4) {
        xhr.abort();
        $("#statusMessage").text("❌ Carga cancelada por el usuario.");
    }

    $("#fileInput").val("");
    $("#statusMessage").text("Listo para subir");
    $("#progressBar")
        .css("width", "0%")
        .text("0%")
        .removeClass("bg-success bg-danger bg-warning bg-primary");
    $(".progress").hide();
    $("#logBox").html("");

    $("#uploadBtn").prop("disabled", false);
    $("#uploadSpinner").addClass("d-none");
    $("#uploadText").text("Subir");
});