$(document).ready(function () {
    Cargar();

    $("#btnNuevo").click(function (e) {
        MostrarNuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if(event.keyCode == 74 && event.ctrlKey){
            event.preventDefault();
        }
    });

});

function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}

function Cargar() {

    var data = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/cliente",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });


    CargarTabla(data);
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_cliente" },
            { mData: "nit" },
            { mData: "nombre" },
            { mData: "email" },
            { mData: "direccion" },
            //{ mData: "estado" }
        ],
        /*
        createdRow: function( row, data, dataIndex){

            if( data.id_cliente == 1 ){
                $(row).css('background-color', '#e1f9dc'); //9EF395 A497E5  F39B9B
            }
            else if( data.id_cliente > 1 && data.id_cliente <= 2  ){
                $(row).css('background-color', '#A497E5');
            }
            else{
                $(row).css('background-color', '#f9dce0');
            }
        },
        */
        aoColumnDefs: [
            {
                "aTargets": [5],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + "&#39;" + encodeURI(full.id_cliente) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.nit) + "&#39;" +"," + "&#39;" + encodeURI(full.telefono) + "&#39;" + "," + "&#39;" + encodeURI(full.email) + "&#39;" + "," + "&#39;" + encodeURI(full.direccion) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Editar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [6],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + "&#39;" + encodeURI(full.id_cliente) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Borrar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            }

        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}



function MostrarNuevo(){

    $("#hfId").val("");
    $("#txtNit").val("");
    $("#txtNombre").val("");
    $("#txtTelefono").val("");
    $("#txtEmail").val("");
    $("#txtDireccion").val("");

    $("#spTitulo").text("Nuevo cliente");
    $('#nuevoCliente').modal('show');   
}



function Almacenar() {
    
    var id = $("#hfId").val() == "" ? 0 :  $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {
    
    var nit = $("#txtNit").val().trim();
    var nombre = $("#txtNombre").val().trim();
    var telefono = $("#txtTelefono").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var error = "";
    
    if (nit == "") {
        MensajeError("Ingrese nit");
        return;
    }

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/cliente",
        data: {
            nit: nit,
            nombre: nombre,
            direccion: direccion,
            telefono: telefono,
            email: email
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}


function Editar(id, nombre, nit, telefono, email, direccion){

    $("#hfId").val(id);
    $("#txtNombre").val(decodeURI(nombre));
    $("#txtNit").val(decodeURI(nit));
    $("#txtTelefono").val(decodeURI(telefono));
    $("#txtEmail").val(decodeURI(email));
    $("#txtDireccion").val(decodeURI(direccion));
    
    $("#spTitulo").text("Editar cliente " + decodeURI(nombre));
    $('#nuevoCliente').modal('show');
}


function Actualizar(){

    var id = $("#hfId").val();
    var nit = $("#txtNit").val().trim();
    var nombre = $("#txtNombre").val().trim();
    var telefono = $("#txtTelefono").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var error = "";
    
    if (nit == "") {
        MensajeError("Ingrese nit");
        return;
    }

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    $.ajax({
        async: false,
        type: "PUT",
        url: "/cliente",
        data: {
            id: id,
            nit: nit,
            nombre: nombre,
            direccion: direccion,
            telefono: telefono,
            email: email
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#nuevoCliente').modal('hide');
}


function Borrar(id, nombre){

    $("#hfId").val(decodeURI(id));
    $("#spTextoBorrar").html("¿Esta seguro de eliminar el registro de " + decodeURI(nombre) + "?");
    $('#modalBorrar').modal('show');
}


function Eliminar(){

    var id = $("#hfId").val();

    $.ajax({
        async: false,
        type: "DELETE",
        url: "/cliente",
        data: {
           id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro eliminado");
    $('#modalBorrar').modal('hide');
}
