const db = require("../models");
const model = db.usuario;
const Op = db.Sequelize.Op;

exports.get = async function (req, res) {

    var id = req.params.id;

    var query = `select id_usuario, upper(nombre) as nombre, upper(apellido) as apellido, 
                upper(usuario) as usuario, email, perfil,
                case
                    when perfil = 1 then 'ADMINISTRADOR'
                    when perfil = 2 then 'SUPERVISOR'
                    when perfil = 3 then 'TÉCNICO'
                end as rol
                from usuario `;

    if (id > 0)
        query += " where id_usuario = " + id;

    await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            res.send({ mensaje: data });
        }).catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

}

exports.post = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.apellido) return res.send({ error: "ingrese apellido" });
    if (!req.body.usuario) return res.send({ error: "ingrese usuario" });
    if (!req.body.email) return res.send({ error: "ingrese email" });
    if (!req.body.clave) return res.send({ error: "ingrese clave" });
    if (!req.body.perfil) return res.send({ error: "ingrese perfil" });
    if (isNaN(req.body.perfil)) return res.send({ error: "ingrese valor numúmerico en perfil " + req.body.perfil });

    var nombre = req.body.nombre;
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe usuario con ese nombre" });

    const hash = await require('crypto').createHash('sha256').update(req.body.clave, 'utf8').digest('hex');

    await model.create({
        nombre: req.body.nombre,
        apellido: req.body.apellido,
        usuario: req.body.usuario,
        email: req.body.email,
        clave: hash,
        estado: 1,
        perfil: req.body.perfil
    })
        .then(data => {
            res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.apellido) return res.send({ error: "ingrese apellido" });
    if (!req.body.usuario) return res.send({ error: "ingrese usuario" });
    if (!req.body.email) return res.send({ error: "ingrese email" });
    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (req.body.id == 1) return res.send({ error: "No se permite modificar el usuario principal" });
    if (!req.body.perfil) return res.send({ error: "ingrese perfil" });
    if (isNaN(req.body.perfil)) return res.send({ error: "ingrese valor numúmerico en perfil " + req.body.perfil });


    var id = req.body.id;
    var usuario = req.body.usuario.toUpperCase();
    var condition = usuario ? { usuario: { [Op.like]: `%${usuario}%` }, id_usuario: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe usuario con ese nombre" });

    await model.update(
        {
            nombre: req.body.nombre,
            apellido: req.body.apellido,
            usuario: req.body.usuario,
            email: req.body.email,
            estado: req.body.estado,
            perfil: req.body.perfil
        },
        {
            where: { id_usuario: id }
        }
    ).then(data => {
        return res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
    })
        .catch(err => {
            return res.send(err);
        });
};


exports.change = async function (req, res) {

    if (!req.body.clave) return res.send({ error: "ingrese clave" });
    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (req.body.id == 1) return res.send({ error: "No se permite modificar el usuario principal" });

    const hash = await require('crypto').createHash('sha256').update(req.body.clave, 'utf8').digest('hex');
    const id = req.body.id;

    await model.update(
        {
            clave: hash,
            estado: 1
        },
        {
            where: { id_usuario: id }
        }
    )
        .then(data => {
            return res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            return res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (req.body.id == 1) return res.send({ error: "No se permite borrar el usuario principal" });
    let id = req.body.id;

    var query = `select count(*) as facturas
                from factura 
                where id_usuario = ${id}`;

    var real = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return data[0];
        });


    if (real.facturas > 0)
        return res.send({ error: "No es posible borrar un usuario cuando posee facturas asociadas" });


    await model.destroy({
        where: { id_usuario: id }
    })
        .then(data => {
            return res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            return res.send(err);
        })

};

exports.validate = async function (usuario, clave) {

    var condition = usuario ? { usuario: { [Op.like]: `%${usuario}%` } } : null;
    var user = await model.findOne({ where: condition });

    if (!user) return { error: "usuario no existe", mensaje: false };

    var hash = require('crypto').createHash('sha256').update(clave, 'utf8').digest('hex');
    var salida = await Compare(hash, user.clave);

    if (!salida) return { error: "clave incorrecta", mensaje: false };
    return { error: "", mensaje: salida, id: user.id_usuario, perfil: user.perfil };
};


exports.current = function (req, res) {
    return res.send({ error: "", mensaje: req.session.usuario.toUpperCase() });
};

async function Compare(pass, hashed) {
    return hashed == pass ? true : false;
}