const { request } = require("express");
const db = require("../models");
const model = db.producto;
const detalle = db.detalle;
const Op = db.Sequelize.Op;
const util = require("./util");

var ejs = require('ejs');

exports.get = function (req, res) {

    var query = `select a.id_producto, a.id_envase, b.nombre as envase, a.nombre, format(a.costo, 2) as costo,  format(a.precio, 2) as precio, a.existencia, a.catalogo, 
                a.ubicacion,
                case 
                    when a.ubicacion is null then '' else upper(a.ubicacion)
                end as ubicacion,
                format(a.precio * a.existencia, 2) as capital
                from producto a
                inner join envase b on a.id_envase  = b.id_envase `;

    const id = req.params.id;

    if (id) query += ` where id_producto = '${id}'  `;
    query += " order by a.id_producto desc";

    db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return res.send({ mensaje: data, error: "", perfil: req.session.perfil });
        }).catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

}

exports.findById = function (req, res) {

    let id = req.params.id;
    model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.envase) return res.send({ error: "ingrese envase" });
    if (isNaN(req.body.envase)) return res.send({ error: "ingrese valor numúmerico en envase" + req.body.envase });
    if (!req.body.costo) return res.send({ error: "ingrese costo" });
    if (isNaN(req.body.costo)) return res.send({ error: "ingrese valor numúmerico en costo" });
    if (!req.body.precio) return res.send({ error: "ingrese precio" });
    if (isNaN(req.body.precio)) return res.send({ error: "ingrese valor numúmerico en precio" });
    if (!req.body.existencia) return res.send({ error: "ingrese existencia" });
    if (isNaN(req.body.existencia)) return res.send({ error: "ingrese valor numúmerico en existencia" });

    var nombre = req.body.nombre.toUpperCase();
    var envase = req.body.envase;
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` }, id_envase: { [Op.eq]: envase } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe producto con ese envase" });

    model.create({
        nombre: req.body.nombre.toUpperCase(),
        id_envase: req.body.envase,
        costo: req.body.costo,
        precio: req.body.precio,
        existencia: req.body.existencia,
        inicial: req.body.existencia,
        ubicacion: req.body.ubicacion
    })
        .then(data => {
            res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.envase) return res.send({ error: "ingrese envase" });
    if (isNaN(req.body.envase)) return res.send({ error: "ingrese valor numúmerico en envase " + req.body.envase });
    if (!req.body.costo) return res.send({ error: "ingrese costo" });
    if (isNaN(req.body.costo)) return res.send({ error: "ingrese valor numúmerico en costo" });
    if (!req.body.precio) return res.send({ error: "ingrese precio" });
    if (isNaN(req.body.precio)) return res.send({ error: "ingrese valor numúmerico en precio" });
    if (!req.body.existencia) return res.send({ error: "ingrese existencia" });
    if (isNaN(req.body.existencia)) return res.send({ error: "ingrese valor numúmerico en existencia" });
    if (!req.body.id) return res.send({ error: "ingrese id" });

    var id = req.body.id;
    var envase = req.body.envase;
    var nombre = req.body.nombre.toUpperCase();
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` }, id_envase: { [Op.eq]: envase }, id_producto: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe envase con ese nombre" });

    model.update(
        {
            nombre: req.body.nombre.toUpperCase(),
            id_envase: req.body.envase,
            costo: req.body.costo,
            precio: req.body.precio,
            existencia: req.body.existencia,
            inicial: req.body.existencia,
            ubicacion: req.body.ubicacion
        },
        {
            where: { id_producto: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });

    let id = req.body.id;
    var condition = id ? { id_producto: id } : null;
    var registros = await detalle.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "el producto esta relacionado a facturas" });

    model.destroy({
        where: { id_producto: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.catalogo = async function (req, res) {

    var query = `select a.id_producto as id, a.nombre, b.nombre as envase 
                from producto a
                inner join envase b on a.id_envase  = b.id_envase
                where catalogo = 1
                order by  a.nombre, b.nombre `;

    var productos = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return data;
        });

    if (productos.length == 0) return res.send({ error: "no hay productos marcados" });

    var template = "./templates/catalogo.html";
    var detalle = [];

    for (var i = 0; i < productos.length; i++) {
        var reg = productos[i];
        var id = PadLeft(reg.id, 4);
        var dto = { codigo: id, producto: reg.nombre, envase: reg.envase };
        detalle.push(dto);
    }

    var html = await ejs.renderFile(template, { detalle: detalle }, { async: true });
    var base64 = await util.generatePDF(html);

    var nombre = "catalogo-marcados.pdf";
    return res.send({ error: "", base64: base64, nombre: nombre });
};


exports.barras = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });

    try {

        var id = req.body.id;
        var valor = PadLeft(id, 4);
        var template = "./templates/eti2.html";
        var detalle = [];
        var tamanio = 10;

        for (var i = 0; i < tamanio; i++) 
            detalle.push(valor);

        var texto = await util.formatoConCeros(id, 4);
        var base64 = await util.GenerarBarra(texto);
        var html = await ejs.renderFile(template, { detalle: detalle, base64: base64 }, { async: true });
        //var salida = await util.generatePDF(html);

        var nombre = "etiquetas-" + id + ".pdf";
        return res.send({ error: "", html, nombre });
        //return res.send({ error: salida.error, base64: salida.base64, nombre: nombre });
        //return res.send({ error: "", base64: buffer.toString('base64'), nombre: nombre });

    } catch (err) {
        return res.send({ error: err.message });
    }
}

// async function GenerarBarra(texto) {
//     var JsBarcode = require('jsbarcode');

//     var { createCanvas } = require("canvas");
//     var canvas = createCanvas();
//     await JsBarcode(canvas, texto);
//     var base64Data = canvas.toDataURL().split(',')[1];

//     return "data:image/png;base64," + base64Data;
// }

// async function formatoConCeros(numero, longitud) {

//     let numeroComoCadena = String(numero);
//     let cerosFaltantes = longitud - numeroComoCadena.length;

//     for (let i = 0; i < cerosFaltantes; i++) {
//         numeroComoCadena = '0' + numeroComoCadena;
//     }

//     return numeroComoCadena;
// }


function PadLeft(value, length) {
    return (value.toString().length < length) ? PadLeft("0" + value, length) :
        value;
}

// async function generatePDF(htmlContent) {

//     const axios = require('axios');
//     const apiUrl = 'http://html-pdf.code-makers.com';

//     // Configuración del cuerpo de la solicitud
//     const data = { html: htmlContent };
//     let base64 = "";

//     // Realizar la solicitud POST
//     await axios.post(apiUrl, data)
//         .then(response => {
//             base64 = response.data.base64;
//         })
//         .catch(error => {
//             throw error.message;
//         });

//     return base64;

//     // const toBufferAsync = () => new Promise((resolve, reject) => {
//     //     pdf.create(htmlContent).toBuffer((err, buffer) => {
//     //         if (err) {
//     //             reject(err);
//     //         } else {
//     //             resolve(buffer);
//     //         }
//     //     });
//     // });

//     // return await toBufferAsync();
// }



async function Externo() {
    var url = 'http://132.148.82.208/reportes-nivel/home/catalogo';

    request.post(url, {
        json: {
            productos: productos
        }
    }, (err, exit, body) => {
        if (err) return res.send({ error: err });

        var nombre = "catalogo-marcados.pdf";
        return res.send({ error: "", base64: body.base64, nombre: nombre });
    });
}