const ejs = require('ejs');

const db = require("../models");
const model = db.catologo;
const catalogoProducto = db.catalogo_producto;
const Op = db.Sequelize.Op;
const util = require("./util");

exports.get = async function (req, res) {

    const id = req.params.id;
    var condition = id ? { id_catalogo: id } : null;

    await model.findAll({ where: condition, order: [['nombre', 'ASC']], })
        .then(data => {
            return res.send({ mensaje: data, error: "" });
        })
        .catch(err => {
            return res.status(500).send({ error: err.message || "Some error occurred while retrieving tutorials." });
        });
}

exports.findById = async function (req, res) {

    let id = req.params.id;
    await model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });

    var nombre = req.body.nombre;
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe catálogo con ese nombre" });

    await model.create({
        nombre: req.body.nombre.toUpperCase(),
    })
        .then(data => {
            return res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            return res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.id) return res.send({ error: "ingrese id" });


    var id = req.body.id;
    var nombre = req.body.nombre.toUpperCase();
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` }, id_catalogo: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe catálogo con ese nombre" });

    await model.update(
        {
            nombre: nombre
        },
        {
            where: { id_envase: id }
        }
    )
        .then(data => {
            return res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            return res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    const t = await db.sequelize.transaction();

    let id = req.body.id;
    var condition = id ? { id_catalogo: id } : null;
    var registros = await catalogoProducto.findAll({ where: condition })
        .then(data => {
            return data;
        })
        .catch(err => {
            return res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    try {

        for (var key in registros) {
            var dto = registros[key];

            await catalogoProducto.destroy({
                where: { id_catalogo_producto: dto.id_catalogo_producto }
            }, { transaction: t });
        }

        await model.destroy({
            where: { id_catalogo: id }
        }, { transaction: t });

        await t.commit();
        return res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
    }
    catch (err) {
        await t.rollback();
        return res.send({ error: err.message });
    }
};


exports.download = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (isNaN(req.body.id)) return res.send({ error: "ingrese valor numúmerico en id" + req.body.id });
    if (!req.body.catalogo) return res.send({ error: "ingrese catalogo" });

    try {

        var id = req.body.id;
        var catalogo = req.body.catalogo;

        var query = `select a.id_producto as id, a.nombre, b.nombre as envase 
                from producto a
                inner join envase b on a.id_envase  = b.id_envase
                inner join catalogo_producto c on c.id_producto = a.id_producto 
                where c.id_catalogo = ${id}
                order by c.id_catalogo_producto asc `;

        var productos = await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
            .then(data => {
                return data;
            });

        if (productos.length == 0) return res.send({ error: "no hay productos asociados" });

        var template = "./templates/catalogo.html";
        var detalle = [];

        for (var i = 0; i < productos.length; i++) {
            var reg = productos[i];
            var id = reg.id;
            var texto = await util.formatoConCeros(id, 4);
            //var barra = req.protocol + '://' + req.get('host') + "/barcode?data=" + texto;
            //console.log(ruta);
            var barra = await util.GenerarBarra(texto);
            var dto = { codigo: texto, producto: reg.nombre, envase: reg.envase, barra: barra };
            detalle.push(dto);
        }

        var html = await ejs.renderFile(template, { detalle: detalle, catalogo: catalogo }, { async: true });
        //var salida = await util.generatePDF(html);
        var nombre = "catalogo-productos.pdf";
        return res.send({ error: "", html, nombre });

        //return res.send({ error: salida.error, base64: salida.base64, nombre });

    } catch (err) {
        return res.send({ error: err.message });
    }
};
