$(document).ready(function () {

    CargarDatos();
    Cargar();


    $("#btnCrearEnvase").click(function (e) {
        MOstrarNuevoEnvase();
        return true;
    });

    $("#btnNuevoEnvase").click(function (e) {
        InsertarEnvase();
        return true;
    });

    $("#btnNuevo").click(function (e) {
        MostrarNuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });


    $("#btnComprar").click(function (e) {
        Comprar();
        return true;
    });


    $("#btnCatalogo").click(function (e) {
        Catalogo();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if (event.keyCode == 74 && event.ctrlKey) {
            event.preventDefault();
        }
    });


});


function InsertarEnvase() {

    var nombre = $("#txtEnvase").val().trim();
    var error = "";

    if (nombre == "") {
        MensajeError("input container");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/envase",
        data: {
            nombre: nombre
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    CargarDatos();

    MensajeExitoso("record saved");
    $('#nuevoEnvase').modal('hide');
}


function CargarDatos() {

    var productos = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/envase",
        data: {
        },
        success: function (result) {
            productos = result.mensaje;
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    var html = '<option value="0">Select Container</option>';

    $.map(productos, function (val, i) {
        html += '<option value="' + val.id_envase + '">' + val.nombre + '</option>';
    });

    $("#ddlEnvase").html(html);
    $("#ddlEnvaseCompra").html(html);

}


function Cargar() {

    var data = [];
    var perfil = 0;
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/producto",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
            perfil = result.perfil;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });

    CargarTabla(data, perfil);
}


function CargarTabla(dataSet, perfil) {

    $("#thCapital").hide();
    var admin = 5;

    if (perfil == admin)
        $("#thCapital").show();

    var dom = perfil < 3 ? "Bfrtip" : "frtip";
    var index = perfil == admin ? 6 : 5;

    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_producto" },
            { mData: "envase" },
            { mData: "nombre" },
            { mData: "existencia", "className": "text-center" },
            { mData: "precio", "className": "text-right" },
            { mData: "ubicacion", "className": "text-center" },
            { mData: "capital", "className": "text-right" }
        ],
        /*
        createdRow: function( row, data, dataIndex){

            if( data.id_cliente == 1 ){
                $(row).css('background-color', '#e1f9dc'); //9EF395 A497E5  F39B9B
            }
            else if( data.id_cliente > 1 && data.id_cliente <= 2  ){
                $(row).css('background-color', '#A497E5');
            }
            else{
                $(row).css('background-color', '#f9dce0');
            }
        },
        */
        aoColumnDefs: [
            {
                "aTargets": [index + 1],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + "&#39;" + encodeURI(full.id_producto) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + full.id_envase + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.costo) + "&#39;" + "," + "&#39;" + encodeURI(full.precio) + "&#39;" + "," + "&#39;" + encodeURI(full.existencia) + "&#39;" + "," + "&#39;" + encodeURI(full.catalogo) + "&#39;" + "," + "&#39;" + encodeURI(full.ubicacion) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Edit"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [index + 2],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + "&#39;" + encodeURI(full.id_producto) + "&#39;" + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Delete"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [index + 3],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Barras(' + "&#39;" + encodeURI(full.id_producto) + "&#39;" + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-danger btn-md" style="display:' + '" title="Download"><span class="glyphicon glyphicon-barcode"></span></a>';
                }
            },
            {
                "aTargets": [index + 4],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Compras(' + "&#39;" + encodeURI(full.id_producto) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + full.id_envase + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.costo) + "&#39;" + "," + "&#39;" + encodeURI(full.precio) + "&#39;" + "," + "&#39;" + encodeURI(full.existencia) + "&#39;" + "," + "&#39;" + encodeURI(full.catalogo) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Purchases"><span class="glyphicon glyphicon-barcode"></span></a>';
                }
            },

        ],
        // language: {
        //     sProcessing: "Procesando...",
        //     sLoadingRecords: "Cargando...",
        //     sInfoFiltered: "(filtrando un total de _MAX_ registros)",
        //     lengthMenu: "Se muestran _MENU_ registros por página",
        //     sZeroRecords: "No se encontraron resultados",
        //     sEmptyTable: "Ningún dato disponible en esta tabla",
        //     info: "Mostrando página _PAGE_ de _PAGES_",
        //     infoEmpty: "No hay registros disponibles",
        //     search: "Búsqueda",
        //     paginate: {
        //         sFirst: "Primero",
        //         sLast: "Último",
        //         previous: "Anterior",
        //         next: "Siguiente"
        //     },
        //     infoFiltered: "(filtered from _MAX_ total records)"
        // },
        dom: dom,
        buttons:
            [
                'pdfHtml5',
                'excelHtml5'
            ]

    });

    /*
    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
    */
}


function MostrarNuevo() {

    $("#txtExistencia").removeAttr('disabled');

    $("#hfId").val("");
    $("#txtNombre").val("");
    $("#txtCosto").val("");
    $("#txtPrecio").val("");
    $("#txtExistencia").val("");
    $("#txtUbicacion").val("");
    $("#ddlEnvase").val(0);
    $("#ddlCatalogo").val(0);

    $("#spTitulo").text("New Product");
    $('#nuevoProducto').modal('show');
}


function MOstrarNuevoEnvase() {
    $("#txtEnvase").val("");
    $('#nuevoEnvase').modal('show');
}


function Almacenar() {

    var id = $("#hfId").val() == "" ? 0 : $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {

    var nombre = $("#txtNombre").val().trim();
    var envase = $("#ddlEnvase").val();
    var costo = $("#txtCosto").val().trim();
    var precio = $("#txtPrecio").val().trim();
    var existencia = $("#txtExistencia").val().trim();
    var ubicacion = $("#txtUbicacion").val();
    var error = "";

    if (nombre == "") {
        MensajeError("Input Name");
        return;
    }

    if (envase == 0) {
        MensajeError("Input Container");
        return;
    }

    if (costo == "") {
        MensajeError("Input Cost");
        return;
    }

    if (isNaN(costo)) {
        MensajeError("Input numeric value in cost");
        return;
    }

    if (precio == "") {
        MensajeError("Input Price");
        return;
    }

    if (isNaN(precio)) {
        MensajeError("Input numeric value in price");
        return;
    }

    if (parseFloat(precio) < parseFloat(costo)) {
        MensajeError("The price cannot be lower than the cost");
        return;
    }

    /*
    if (existencia == "") {
        MensajeError("Ingrese existencia");
        return;
    }

    if (isNaN(existencia)) {
        MensajeError("Ingrese valor númerico en existencia");
        return;
    }
    */

    $.ajax({
        async: false,
        type: "POST",
        url: "/producto",
        data: {
            nombre: nombre,
            envase: envase,
            costo: costo,
            precio: precio,
            existencia: existencia,
            ubicacion: ubicacion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record saved");
    $('#nuevoProducto').modal('hide');
}


function Editar(id, nombre, idEnvase, envase, costo, precio, existencia, catalogo, ubicacion) {

    $("#txtExistencia").attr('disabled', 'disabled');

    $("#hfId").val(id);
    $("#txtNombre").val(decodeURI(nombre));
    $("#ddlEnvase").val(idEnvase);
    $("#txtCosto").val(decodeURI(costo));
    $("#txtPrecio").val(decodeURI(precio));
    $("#txtExistencia").val(decodeURI(existencia));
    $("#ddlCatalogo").val(decodeURI(catalogo));
    $("#txtUbicacion").val(decodeURI(ubicacion));

    $("#myModalLabel").text("Edit product " + decodeURI(envase) + " " + decodeURI(nombre));
    $('#nuevoProducto').modal('show');
}


function Actualizar() {

    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();
    var envase = $("#ddlEnvase").val();
    var costo = $("#txtCosto").val().trim();
    var precio = $("#txtPrecio").val().trim();
    var existencia = $("#txtExistencia").val().trim();
    var ubicacion = $("#txtUbicacion").val();
    var error = "";

    if (nombre == "") {
        MensajeError("Input name");
        return;
    }

    if (envase == 0) {
        MensajeError("Input container");
        return;
    }

    if (costo == "") {
        MensajeError("Input cost");
        return;
    }

    if (isNaN(costo)) {
        MensajeError("Input numeric value in cost");
        return;
    }

    if (precio == "") {
        MensajeError("Input price");
        return;
    }

    if (isNaN(precio)) {
        MensajeError("Input numeric value in price");
        return;
    }

    if (parseFloat(precio) < parseFloat(costo)) {
        MensajeError("The price cannot be lower than the cost");
        return;
    }

    /*
    if (existencia == "") {
        MensajeError("Ingrese existencia");
        return;
    }

    if (isNaN(existencia)) {
        MensajeError("Ingrese valor númerico en existencia");
        return;
    }
    */

    $.ajax({
        async: false,
        type: "PUT",
        url: "/producto",
        data: {
            id: id,
            nombre: nombre,
            envase: envase,
            costo: costo,
            precio: precio,
            existencia: existencia,
            ubicacion: ubicacion
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record saved");
    $('#nuevoProducto').modal('hide');
}


function Borrar(id, envase, nombre) {

    $("#hfId").val(decodeURI(id));
    $("#spTextoBorrar").html("Are you sure to delete record from " + decodeURI(envase) + " " + decodeURI(nombre) + "?");
    $('#modalBorrar').modal('show');
}


function Eliminar() {

    var id = $("#hfId").val();

    $.ajax({
        async: false,
        type: "DELETE",
        url: "/producto",
        data: {
            id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record deleted");
    $('#modalBorrar').modal('hide');
}


function Catalogo() {

    var error = "";
    var base64 = "";
    var nombre = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/producto/catalogo",
        data: {
        },
        success: function (result) {
            error = result.error;
            base64 = result.base64;
            nombre = result.nombre;
        },
        error: function (errMsg) {
            error = errMsg.responseText;
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    DescargarArchivo(base64, nombre, "application/octet-stream");
}


function replaceNewLines(inputString) {
    // Reemplazar todas las ocurrencias de \r\n por ""
    return inputString.replace(/\r\n/g, "");
}


async function Barras(id, envase, producto) {

    try {
        $("#divLoading").show();

        var descripcion = decodeURI(envase) + " " + decodeURI(producto);
        var parametros = { id: id, descripcion: descripcion };
        var info = await postProcess("/producto/barras", parametros);

        if (info.error != "") {
            MensajeError(info.error);
            return;
        }

        await DescargarPDF(info.html, info.nombre);
        //DescargarArchivo(info.base64, info.nombre, "application/octet-stream");

    } catch (err) {
        MensajeError(err.message);
    } finally {
        $("#divLoading").hide();
    }

    
}


function DescargarArchivo(base64, nombre, mime) {

    var ua = window.navigator.userAgent;
    var msie = ua.indexOf('MSIE ');
    var trident = ua.indexOf('Trident/');
    var edge = ua.indexOf('Edge/');
    var esIE = false;


    var binary_string = window.atob(base64);
    //var binary_string = window.atob(str64);
    var len = binary_string.length;
    var bytes = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
        bytes[i] = binary_string.charCodeAt(i);
    }

    var nuevoArray = bytes.buffer;
    var blob = new Blob([nuevoArray], { type: mime });

    if (msie > 0 || trident > 0 || edge > 0) {
        window.navigator.msSaveOrOpenBlob(blob, nombre);
        return;
    }

    var a = document.createElement("a");
    document.body.appendChild(a);
    a.style = "display: block";

    url = window.URL.createObjectURL(blob);
    a.href = url;
    a.download = nombre;
    a.click();
    window.URL.revokeObjectURL(url);
}


function Compras(id, nombre, idEnvase, envase, costo, precio, existencia, catalogo) {

    $("#hfId").val(id);
    $("#txtNombreCompra").val(decodeURI(nombre));
    $("#ddlEnvaseCompra").val(idEnvase);
    $("#txtCostoCompra").val(decodeURI(costo));
    $("#txtPrecioCompra").val(decodeURI(precio));
    $("#txtCantidadCompra").val(0);
    $("#ddlCatalogoCompra").val(decodeURI(catalogo));

    $("#spCompra").text("Product purchase " + decodeURI(envase) + " " + decodeURI(nombre));
    $('#compraProducto').modal('show');
}


function Comprar() {

    var id = $("#hfId").val();
    var nombre = $("#txtNombreCompra").val().trim();
    var envase = $("#ddlEnvaseCompra").val();
    var costo = $("#txtCostoCompra").val().trim();
    var precio = $("#txtPrecioCompra").val().trim();
    var cantidad = $("#txtCantidadCompra").val().trim();
    var catalogo = $("#ddlCatalogoCompra").val();
    var error = "";

    if (nombre == "") {
        MensajeError("Input name");
        return;
    }

    if (envase == 0) {
        MensajeError("Input container");
        return;
    }

    if (costo == "") {
        MensajeError("Input cost");
        return;
    }

    if (isNaN(costo)) {
        MensajeError("Input numeric value in cost");
        return;
    }

    if (precio == "") {
        MensajeError("Input price");
        return;
    }

    if (isNaN(precio)) {
        MensajeError("Input numeric value in price");
        return;
    }

    if (parseFloat(precio) < parseFloat(costo)) {
        MensajeError("The price cannot be lower than the cost");
        return;
    }

    if (cantidad == "") {
        MensajeError("Input quantity");
        return;
    }

    if (isNaN(cantidad)) {
        MensajeError("Input numeric value in quantity");
        return;
    }

    if (cantidad == 0) {
        MensajeError("Ingrese cantidad mayor a cero");
        return;
    }

    $.ajax({
        async: true,
        type: "POST",
        url: "/compra",
        data: {
            id_producto: id,
            nombre: nombre,
            envase: envase,
            costo: costo,
            precio: precio,
            cantidad: cantidad,
            catalogo: catalogo
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;

            if (error != "") {
                MensajeError(error);
                return;
            }

            Cargar();

            MensajeExitoso("record saved");
            $('#compraProducto').modal('hide');
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });
}


async function DescargarPDF(html, nombre) {

    const { jsPDF } = window.jspdf;
    const doc = new jsPDF({ format: 'letter' });

    await doc.html(html, {
        callback: function (doc) {
            doc.save(nombre);
        },
        x: 10,
        y: 10,
        html2canvas: { scale: 0.17 }
    });
}


function DescargarPDF2(html, nombre) {

    var pdf = new jsPDF('p', 'pt', 'letter', [300, 300]);

    margins = {
        top: 10,
        //bottom: 60,
        left: 10,
        width: 600
    };

    pdf.fromHTML(
        html,
        margins.left, // x coord
        margins.top, { // y coord
        'width': margins.width,
    },

        function (dispose) {
            pdf.save(nombre);
        }, margins,

    );
}