const db = require("../models");
const model = db.envase;
const producto = db.producto;
const Op = db.Sequelize.Op;


exports.get = async function (req, res) {

    const id = req.params.id;
    var condition = id ? { id_envase: id } : null;

    await model.findAll({ where: condition, order: [['nombre', 'ASC']], })
        .then(data => {
            res.send({ mensaje: data, error: "" });
        })
        .catch(err => {
            res.status(500).send({ error: err.message || "Some error occurred while retrieving tutorials." });
        });
}

exports.findById = async function (req, res) {

    let id = req.params.id;
    await model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });

    var nombre = req.body.nombre;
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe envase con ese nombre" });

    await model.create({
        nombre: req.body.nombre.toUpperCase(),
    })
        .then(data => {
            res.send({ mensaje: "Registro almacenado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.put = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.id) return res.send({ error: "ingrese id" });


    var id = req.body.id;
    var nombre = req.body.nombre.toUpperCase();
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` }, id_envase: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe envase con ese nombre" });

    await model.update(
        {
            nombre: nombre
        },
        {
            where: { id_envase: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });

    let id = req.body.id;
    var condition = id ? { id_envase: id } : null;
    var registros = await producto.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "No es posible borrar un envase cuando tiene productos asociados" });

    await model.destroy({
        where: { id_envase: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};