const passport = require('passport');
const LocalStrategy = require('passport-local');
const Usuario = require('../models/usuario');
const bcrypt = require('bcrypt');

passport.serializeUser(function (user, done) {
    done(null, user.id_usuario);
});

passport.deserializeUser(function (id, done) {
    Usuario.findByPk(id, function (err, user) {
        done(err, user);
    });
});


passport.use(new LocalStrategy(
    {
        usernameField: 'usuario', function(usuario, clave, done) {

            var condition = usuario ? { usuario: { [Op.like]: `%${usuario}%` } } : null;
            var user = model.findOne({ where: condition });

            if (!user) return done(null, false, { error: "el usuario no está registrado" });

            bcrypt.compare(clave, user.clave, function (err, result) {

                if (err) return done(null, false, { error: "error al verificar clave" });
                if (!result) return done(null, false, { error: "clave incorrecta" });
                return done(null, user);

            });
        }
    })
);


exports.estaAutenticado(function (req, res, next) {
    if (req.isAutenticated()) return next();
    return res.status(401).send({ error: "el usuario no está autenticado" });
})


