$(document).ready(function () {
    Cargar();

    $("#btnNuevo").click(function (e) {
        MostrarNuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if (event.keyCode == 74 && event.ctrlKey) {
            event.preventDefault();
        }
    });

});

function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}

function Cargar() {

    var data = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/usuario",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });


    CargarTabla(data);
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_usuario" },
            { mData: "nombre" },
            { mData: "apellido" },
            { mData: "usuario" },
            { mData: "email" },
            { mData: "rol" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [6],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + "&#39;" + encodeURI(full.id_usuario) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.apellido) + "&#39;" + "," + "&#39;" + encodeURI(full.email) + "&#39;" + "," + "&#39;" + encodeURI(full.usuario) + "&#39;" + "," + "&#39;" + encodeURI(full.perfil) + "&#39;" + "," + "&#39;" + encodeURI(full.perfil) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Editar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [7],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + "&#39;" + encodeURI(full.id_usuario) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Borrar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [8],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:MostrarClave(' + "&#39;" + encodeURI(full.id_usuario) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-danger btn-md" style="display:' + '" title="Cambiar"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            }

        ],
        language: {
            sProcessing: "Procesando...",
            sLoadingRecords: "Cargando...",
            sInfoFiltered: "(filtrando un total de _MAX_ registros)",
            lengthMenu: "Se muestran _MENU_ registros por página",
            sZeroRecords: "No se encontraron resultados",
            sEmptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando página _PAGE_ de _PAGES_",
            infoEmpty: "No hay registros disponibles",
            search: "Búsqueda",
            paginate: {
                sFirst: "Primero",
                sLast: "Último",
                previous: "Anterior",
                next: "Siguiente"
            },
            infoFiltered: "(filtered from _MAX_ total records)"
        }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}



function MostrarNuevo() {

    $("#hfId").val("");
    $("#txtNombre").val("");
    $("#txtApellido").val("");
    $("#txtUsuario").val("");
    $("#txtEmail").val("");
    $("#txtClave").val("");
    $("#txtDuplicado").val("");
    $("#ddlPerfil").val(0);

    $("#divClave").show();
    $("#divUsuario").show();
    $("#spTituloPro").text("Nuevo usuario");
    $('#modalNuevo').modal('show');
}



function Almacenar() {

    var id = $("#hfId").val() == "" ? 0 : $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {

    var nombre = $("#txtNombre").val().trim();
    var apellido = $("#txtApellido").val().trim();
    var usuario = $("#txtUsuario").val().trim();
    var email = $("#txtEmail").val().trim();
    var clave = $("#txtClave").val().trim();
    var duplicado = $("#txtDuplicado").val().trim();
    var idPerfil = $("#ddlPerfil").val();
    var error = "";

    if (nombre == "") {
        MensajeError("Ingrese nombre");
        return;
    }

    if (apellido == "") {
        MensajeError("Ingrese apellido");
        return;
    }

    if (usuario == "") {
        MensajeError("Ingrese usuario");
        return;
    }

    if (idPerfil == 0) {
        MensajeError("Elija Perfil");
        return;
    }

    if (clave == "") {
        MensajeError("Ingrese contraseña");
        return;
    }
    if (duplicado == "") {
        MensajeError("Ingrese confirmación");
        return;
    }

    if (duplicado != clave) {
        MensajeError("La contraseña y la confirmación son diferentes ");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/usuario",
        data: {
            nombre: nombre,
            apellido: apellido,
            email: email,
            usuario: usuario,
            clave: clave,
            perfil: idPerfil
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#modalNuevo').modal('hide');
}


function Editar(id, nombre, apellido, email, usuario, perfil) {

    $("#hfId").val(id);
    $("#txtNombre").val(decodeURI(nombre));
    $("#txtApellido").val(decodeURI(apellido));
    $("#txtUsuario").val(decodeURI(usuario));
    $("#txtEmail").val(decodeURI(email));
    $("#ddlPerfil").val(decodeURI(perfil));

    $("#divClave").hide();
    $("#divUsuario").show();

    $("#hfClave").val("");
    $("#spTituloPro").text("Editar usuario");
    $('#modalNuevo').modal('show');
}


function MostrarClave(id) {

    $("#hfId").val(id);
    $("#txtClave").val("");
    $("#txtDuplicado").val("");

    $("#hfClave").val(id);
    $("#divClave").show();
    $("#divUsuario").hide();
    $("#spTituloPro").text("Editar Clave");
    $('#modalNuevo').modal('show');
}


function Actualizar() {

    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();
    var apellido = $("#txtApellido").val().trim();
    var usuario = $("#txtUsuario").val().trim();
    var email = $("#txtEmail").val().trim();
    var clave = $("#txtClave").val().trim();
    var duplicado = $("#txtDuplicado").val().trim();
    var cambio = $("#hfClave").val().trim();
    var idPerfil = $("#ddlPerfil").val();
    var url = $("#hfClave").val().trim() == "" ? "/usuario" : "/usuario/clave";

    var error = "";

    if (cambio == "") {

        if (nombre == "") {
            MensajeError("Ingrese nombre");
            return;
        }

        if (apellido == "") {
            MensajeError("Ingrese apellido");
            return;
        }

        if (usuario == "") {
            MensajeError("Ingrese usuario");
            return;
        }

        if (idPerfil == 0) {
            MensajeError("Elija Perfil");
            return;
        }

    }
    else {

        if (clave == "") {
            MensajeError("Ingrese contraseña");
            return;
        }
        if (duplicado == "") {
            MensajeError("Ingrese confirmación");
            return;
        }

        if (duplicado != clave) {
            MensajeError("La contraseña y la confirmación son diferentes ");
            return;
        }
    }

    

    $.ajax({
        async: false,
        type: "PUT",
        url: url,
        data: {
            id: id,
            nombre: nombre,
            apellido: apellido,
            email: email,
            usuario: usuario,
            clave: clave,
            perfil: idPerfil
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro almacenado");
    $('#modalNuevo').modal('hide');
}


function Borrar(id, nombre) {

    $("#hfId").val(decodeURI(id));
    $("#spTextoBorrar").html("¿Esta seguro de eliminar el registro de " + decodeURI(nombre) + "?");
    $('#modalBorrar').modal('show');
}


function Eliminar() {

    var id = $("#hfId").val();

    $.ajax({
        async: false,
        type: "DELETE",
        url: "/usuario",
        data: {
            id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("registro eliminado");
    $('#modalBorrar').modal('hide');
}
