const dbConfig = require("../config/db.config.js");

const Sequelize = require("sequelize");
const sequelize = new Sequelize(dbConfig.DB, dbConfig.USER, dbConfig.PASSWORD, {
  host: dbConfig.HOST,
  dialect: dbConfig.dialect,
  operatorsAliases: false,
  timezone: '-06:00', 
  pool: {
    max: dbConfig.pool.max,
    min: dbConfig.pool.min,
    acquire: dbConfig.pool.acquire,
    idle: dbConfig.pool.idle
  }
});

const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

//modelos
db.cliente = require("./cliente")(sequelize, Sequelize);
db.envase = require("./envase")(sequelize, Sequelize);
db.producto = require("./producto")(sequelize, Sequelize);
db.compra = require("./compra")(sequelize, Sequelize);
db.perfil = require("./perfil")(sequelize, Sequelize);
db.usuario = require("./usuario")(sequelize, Sequelize);
db.factura = require("./factura")(sequelize, Sequelize);
db.detalle = require("./detalle")(sequelize, Sequelize);
db.catologo = require("./catalogo")(sequelize, Sequelize);
db.catalogo_producto = require("./catalogo_producto")(sequelize, Sequelize);

module.exports = db;
