exports.generatePDF = async function (htmlContent) {

    let pdf = require("html-pdf");
    let error = "";
    let base64 = "";

    if (htmlContent === "") return { error: "ingrese html" };

    try {
        var options = {
            format: 'Letter',
            timeout: 30000
        };

        base64 = await new Promise((resolve, reject) => {
            pdf.create(htmlContent, options).toBuffer((err, buffer) => {
                if (err) return reject(err.message);
                resolve(buffer.toString('base64'));
            });
        });

    } catch (err) {
        error = err.message;
    }

    return { error: error, base64: base64 };

    // const puppeteer = require('puppeteer');

    // let error = "";
    // let base64 = "";

    // try {

    //     const browser = await puppeteer.launch({
    //         args: ['--no-sandbox', '--disable-setuid-sandbox'],
    //         executablePath: '/usr/bin/google-chrome-stable' // Asegúrate de que esta sea la ruta correcta al binario de Chrome
    //     });
    //     const page = await browser.newPage();

    //     // Establece el contenido HTML
    //     await page.setContent(htmlContent, { waitUntil: 'domcontentloaded' });

    //     // Configura las opciones del PDF
    //     const options = {
    //         format: 'letter', // Formato del papel
    //         printBackground: true, // Imprime el fondo de la página
    //     };

    //     // Genera el PDF y obtén los bytes
    //     const pdfBuffer = await page.pdf(options);
    //     base64 = pdfBuffer.toString('base64')

    //     // Cierra el navegador
    //     await browser.close();
    // } catch (err) {
    //     error = err.message;
    // }

    // return { error: error, base64: base64 };




    // let pdf = require("html-pdf");
    // let error = "";
    // let base64 = "";

    // if (htmlContent === "") return { error: "ingrese html" };

    // try {
    //     var options = {
    //         format: 'Letter',
    //         timeout: 30000
    //     };

    //     base64 = await new Promise((resolve, reject) => {
    //         pdf.create(htmlContent, options).toBuffer((err, buffer) => {
    //             if (err) return reject(err.message);
    //             resolve(buffer.toString('base64'));
    //         });
    //     });

    // } catch (err) {
    //     error = err.message;
    // }

    // return { error: error, base64: base64 };


    // "@ironsoftware/ironpdf": "^2024.5.1",
    // const axios = require('axios');

    // if (htmlContent === "")
    //     return res.status(400).json({ error: "Ingrese HTML" });

    // try {
    //     const apiUrl = 'http://192.3.245.177/html-pdf/pdf';
    //     const info = { html: htmlContent };

    //     const response = await axios.post(apiUrl, info);
    //     const data = response.data;

    //     if (data.error || !data.base64)
    //         return res.status(400).json({ error: "Error al generar PDF: " + data.error });

    //     return { error: data.error, base64: data.base64 };

    // } catch (err) {
    //     throw new Error('Error generating pdf:' + err.message);
    // }



    // let pdf = require('html-pdf-node');
    // let options = { format: 'letter', args: ['--no-sandbox', '--disable-setuid-sandbox'] };
    // let file = { content: htmlContent };
    // let base64 = "";
    // let error = "";

    // try {
    //     let buffer = await pdf.generatePdf(file, options);
    //     //base64 = Buffer.from(buffer, 'binary').toString('base64');
    //     base64 = buffer.toString('base64')
    // } catch (err) {
    //     error = err.message;
    // }

    // return { error: error, base64: base64 };


    // const axios = require('axios');

    // //const apiUrl = 'http://localhost:5273/pdf';
    // const apiUrl = 'http://192.3.245.177/html-pdf/pdf';
    // const data = { html: htmlContent };

    // const response = await axios.post(apiUrl, data);
    // return response.data;

    // if (response.data.error != "")
    //     throw new Error(response.data.error);

    // return response.data.base64;

};


exports.GenerarQR = async function (text) {
    // var qrcode = require('qrcode');
    // var base64 = await qrcode.toDataURL(text);
    // return base64;

    const bwipjs = require('bwip-js');

    return new Promise((resolve, reject) => {
        bwipjs.toBuffer({
            bcid: 'qrcode',        // Tipo de código de barras QR
            text: text,            // Texto a codificar
            scale: 3,              // Escala de la imagen
            //height: 10,            // Altura en mm
            includetext: false,    // No incluir el texto debajo del código QR
        }, (err, png) => {
            if (err) {
                return reject(new Error(`Error al generar el código QR: ${err.message}`));
            }

            // Convertir la imagen PNG a Base64
            const base64Image = png.toString('base64');
            const base64 = `data:image/png;base64,${base64Image}`;
            resolve(base64);
        });
    });
}


exports.GenerarBarra = async function (text) {

    const bwipjs = require('bwip-js');

    return new Promise((resolve, reject) => {
        bwipjs.toBuffer({
            bcid: 'code128',      // Tipo de código de barras
            text: text,          // Texto a codificar
            scale: 8,            // Escala de la imagen
            height: 10,          // Altura en mm
            includetext: true,   // Incluir el texto debajo del código de barras
            textxalign: 'center', // Alineación del texto
        }, (err, png) => {
            if (err) 
                return reject(new Error(`Error al generar el código de barras: ${err.message}`));

            // Convertir la imagen PNG a Base64
            const base64Image = png.toString('base64');
            const base64 = `data:image/png;base64,${base64Image}`;
            resolve(base64);
        });
    });
}


exports.formatoConCeros = async function (numero, longitud) {

    let numeroComoCadena = String(numero);
    let cerosFaltantes = longitud - numeroComoCadena.length;

    for (let i = 0; i < cerosFaltantes; i++) {
        numeroComoCadena = '0' + numeroComoCadena;
    }

    return numeroComoCadena;
}


exports.PadLeft = function (value, length) {
    return (value.toString().length < length) ? PadLeft("0" + value, length) :
        value;
}


// module.exports = {
//     miFuncionAsincrona,
// };

// async function generatePDF(html) {

//     const pdf = require("html-pdf");

//     return new Promise((resolve, reject) => {
//         const options = {
//             format: 'Letter',
//             timeout: 15000
//         };

//         pdf.create(html, options).toBuffer((err, buffer) => {
//             if (err) {
//                 reject(err);
//             } else {
//                 const base64 = buffer.toString('base64');
//                 resolve(base64);
//             }
//         });
//     });
// }