$(document).ready(function () {

    CargarDatos();
    CargarProductos();
    CargarTabla([]);
    CargarEnvases();
    CargarUsuario();
    CargarClientes();

    $('#txtNitBuscar').keyup(function () {
        LimpiarCliente();
    });

    $("#btnProducto").click(function (e) {
        MostrarNuevoProducto();
        return true;
    });


    $("#btnProducto").click(function (e) {
        MostrarNuevoProducto();
        return true;
    });

    $("#btnCliente").click(function (e) {
        MostrarNuevoCliente();
        return true;
    });

    $("#btnAlmacenarCliente").click(function (e) {
        AlmacenarCliente();
        return true;
    });


    $("#btnAlmacenarProducto").click(function (e) {
        AlmacenarProducto();
        return true;
    });

    $("#btnAgregar").click(function (e) {
        MostrarProductos();
        return true;
    });

    $("#btnLimpiar").click(function (e) {
        Limpiar();
        return true;
    });

    $("#btnAlmacenarFactura").click(function (e) {
        AlmacenarFactura();
        return true;
    });

    $("#buscarProductos").on("hide.bs.modal", function () {
        $("#txtProductoBuscar").focus();
    });

    document.addEventListener('keydown', function (event) {

        if (event.keyCode == 74 && event.ctrlKey) {
            $("#txtProductoBuscar").focus();
            event.preventDefault();
            AgregarProductoBarra();
        }

    });

    $("#btnImprimir").click(function (e) {
        Imprimir();
        return true;
    });

});


function CargarDatos() {
    $("#btnAlmacenarFactura").prop('disabled', false);
    $("#txtProductoBuscar").focus();
}

function LimpiarCliente() {

    var nit = $('#txtNitBuscar').val().trim();

    if (nit == "") {
        $("#txtNombreBuscar").val("");
        $("#hfIdCliente").val("");
    }
}


function autocomplete(inp, arr) {
    /*the autocomplete function takes two arguments,
    the text field element and an array of possible autocompleted values:*/
    var currentFocus;
    /*execute a function when someone writes in the text field:*/
    inp.addEventListener("input", function (e) {
        var a, b, i, val = this.value;
        /*close any already open lists of autocompleted values*/
        closeAllLists();
        if (!val) { return false; }
        currentFocus = -1;
        /*create a DIV element that will contain the items (values):*/
        a = document.createElement("DIV");
        a.setAttribute("id", this.id + "autocomplete-list");
        a.setAttribute("class", "autocomplete-items");
        /*append the DIV element as a child of the autocomplete container:*/
        this.parentNode.appendChild(a);
        /*for each item in the array...*/
        for (i = 0; i < arr.length; i++) {
            /*check if the item starts with the same letters as the text field value:*/
            if (arr[i].substr(0, val.length).toUpperCase() == val.toUpperCase()) {
                /*create a DIV element for each matching element:*/
                b = document.createElement("DIV");
                /*make the matching letters bold:*/
                b.innerHTML = "<strong>" + arr[i].substr(0, val.length) + "</strong>";
                b.innerHTML += arr[i].substr(val.length);
                /*insert a input field that will hold the current array item's value:*/
                b.innerHTML += "<input type='hidden' value='" + arr[i] + "'>";
                /*execute a function when someone clicks on the item value (DIV element):*/
                b.addEventListener("click", function (e) {
                    /*insert the value for the autocomplete text field:*/
                    inp.value = this.getElementsByTagName("input")[0].value;

                    for (var i = 0; i <= clientes.length; i++) {
                        var dto = clientes[i];
                        console.log(dto);

                        if (dto.convertido == inp.value) {
                            $("#txtNombreBuscar").val(dto.nombre);
                            $("#hfIdCliente").val(dto.id_cliente);
                            $("#txtProductoBuscar").focus();
                            break;
                        }
                    }

                    /*close the list of autocompleted values,
                    (or any other open lists of autocompleted values:*/
                    closeAllLists();
                });
                a.appendChild(b);
            }
        }
    });
    /*execute a function presses a key on the keyboard:*/
    inp.addEventListener("keydown", function (e) {
        var x = document.getElementById(this.id + "autocomplete-list");
        if (x) x = x.getElementsByTagName("div");
        if (e.keyCode == 40) {
            /*If the arrow DOWN key is pressed,
            increase the currentFocus variable:*/
            currentFocus++;
            /*and and make the current item more visible:*/
            addActive(x);
        } else if (e.keyCode == 38) { //up
            /*If the arrow UP key is pressed,
            decrease the currentFocus variable:*/
            currentFocus--;
            /*and and make the current item more visible:*/
            addActive(x);
        } else if (e.keyCode == 13) {
            /*If the ENTER key is pressed, prevent the form from being submitted,*/
            e.preventDefault();
            if (currentFocus > -1) {
                /*and simulate a click on the "active" item:*/
                if (x) x[currentFocus].click();
            }
        }
    });
    function addActive(x) {
        /*a function to classify an item as "active":*/
        if (!x) return false;
        /*start by removing the "active" class on all items:*/
        removeActive(x);
        if (currentFocus >= x.length) currentFocus = 0;
        if (currentFocus < 0) currentFocus = (x.length - 1);
        /*add class "autocomplete-active":*/
        x[currentFocus].classList.add("autocomplete-active");

    }
    function removeActive(x) {
        /*a function to remove the "active" class from all autocomplete items:*/
        for (var i = 0; i < x.length; i++) {
            x[i].classList.remove("autocomplete-active");
        }
    }
    function closeAllLists(elmnt) {
        /*close all autocomplete lists in the document,
        except the one passed as an argument:*/
        var x = document.getElementsByClassName("autocomplete-items");
        for (var i = 0; i < x.length; i++) {
            if (elmnt != x[i] && elmnt != inp) {
                x[i].parentNode.removeChild(x[i]);
            }
        }
    }
    /*execute a function when someone clicks in the document:*/
    document.addEventListener("click", function (e) {
        closeAllLists(e.target);
    });
}


function MostrarProductos() {
    var id = $("#hfId").val() == "" ? 0 : parseInt($("#hfId").val());

    if (id > 0) {
        MensajeError("The invoice is already finalized, please press the 'Clear Invoice' button");
        return;
    }

    $('#buscarProductos').modal('show');
}


function ObtenerFecha() {
    let date = new Date()

    let day = date.getDate()
    let month = date.getMonth() + 1
    let year = date.getFullYear()

    if (month < 10) {
        //console.log(`${day}/0${month}/${year}`)
        return `${day}/0${month}/${year}`;
    } else {
        //console.log(`${day}/${month}/${year}`)
        return `${day}/${month}/${year}`;
    }
}

var clientes = [];
var availableTags = [];
var agotados = [];
function CargarClientes() {

    $.ajax({
        async: false,
        type: "GET",
        url: "/cliente",
        data: {
        },
        success: function (result) {
            clientes = result.mensaje;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    clientes.forEach(element => {
        availableTags.push(element.convertido);
    });

    autocomplete(document.getElementById("txtNitBuscar"), availableTags);
}


function CargarUsuario() {

    var error = "";

    $.ajax({
        async: false,
        type: "POST",
        url: "/usuario/current",
        data: {
        },
        success: function (result) {
            $("#txtVendedor").val(result.mensaje);
            $("#txtFecha").val(ObtenerFecha());
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }
}



function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}


function Limpiar() {

    CargarProductos();
    CargarDatos();
    detalles = [];
    CargarTabla(detalles);

    $("#txtNitBuscar").val("");
    $("#txtNombreBuscar").val("");
    $("#hfIdCliente").val("");
    $("#txtProductoBuscar").val('');
    $("#hfId").val('');

    $("#hfTotal").val("");
    $("#spTotal").text("TOTAL: 0.00");
    $("#btnAlmacenarFactura").prop('disabled', false);
}


function CargarEnvases() {

    var envases = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/envase",
        data: {
        },
        success: function (result) {
            envases = result.mensaje;
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    var html = '<option value="0">Select Container</option>';

    $.map(envases, function (val, i) {
        html += '<option value="' + val.id_envase + '">' + val.nombre + '</option>';
    });

    $("#ddlEnvase").html(html);
}

var productos = [];
function CargarProductos() {

    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/producto",
        data: {
        },
        success: function (result) {
            error = result.error;
            productos = result.mensaje;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    CargarTablaProductos(productos);
}


function MostrarNuevoProducto() {

    var id = $("#hfId").val() == "" ? 0 : parseInt($("#hfId").val());

    if (id > 0) {
        MensajeError("The invoice is already finalized, please press the 'Clear Invoice' button");
        return;
    }

    $("#txtProducto").val("");
    $("#txtCosto").val("");
    $("#txtPrecio").val("");
    $("#txtExistencia").val("");
    $("#ddlEnvase").val(0);
    $("#ddlCatalogo").val(0);

    $("#spTitulo").text("Nuevo Producto");
    $('#nuevoProducto').modal('show');
}


function MostrarNuevoCliente() {

    var id = $("#hfId").val() == "" ? 0 : parseInt($("#hfId").val());

    if (id > 0) {
        MensajeError("The invoice is already finalized, please press the 'Clear Invoice' button");
        return;
    }

    $("#txtNit").val("");
    $("#txtNombre").val("");
    $("#txtTelefono").val("");
    $("#txtEmail").val("");
    $("#txtDireccion").val("");

    $('#nuevoCliente').modal('show');
}


var detalles = [];
function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 15,
        bLengthChange: false,
        ordering: false,
        destroy: true,
        bPaginate: false,
        bFilter: true,
        //bServerSide: false,
        searching: false,
        autoWidth: false,
        info: false,
        aoColumns: [
            { mData: "cantidad" },
            { mData: "descripcion" },
            { mData: "precio", "className": "text-right" },
            { mData: "subtotal", "className": "text-right" }
        ],
        aoColumnDefs: [
            {
                "aTargets": [4],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + full.index + ');" class="btn btn-primary btn-md" style="display:' + '" title="Borrar"><span class="glyphicon glyphicon-trash"></span></a>';
                }
            }
        ],
        // language: {
        //     sProcessing: "Procesando...",
        //     sLoadingRecords: "Cargando...",
        //     sInfoFiltered: "(filtrando un total de _MAX_ registros)",
        //     lengthMenu: "Se muestran _MENU_ registros por página",
        //     sZeroRecords: "No se encontraron resultados",
        //     sEmptyTable: "Ningún dato disponible en esta tabla",
        //     info: "Mostrando página _PAGE_ de _PAGES_",
        //     infoEmpty: "No hay registros disponibles",
        //     search: "Búsqueda",
        //     paginate: {
        //         sFirst: "Primero",
        //         sLast: "Último",
        //         previous: "Anterior",
        //         next: "Siguiente"
        //     },
        //     infoFiltered: "(filtered from _MAX_ total records)"
        // }
    });
}


function CargarTablaProductos(dataSet) {

    var t = $('#tbProductos').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_producto" },
            { mData: "envase" },
            { mData: "nombre" },
            { mData: "existencia" },
            { mData: "precio", "className": "text-center" },
            {
                title: "Cantidad ", "data": "MarkupValue",
                render: function (data, type, row, meta) {
                    var id = "Markup_" + meta.row;
                    return '<input class="form-control trackInput"' + 'id="' + id + '" name="Markup" type="text"  value = ' + 1 + '  >';
                }
            },
        ],
        aoColumnDefs: [
            {
                "title": "Marcar",
                "aTargets": [6],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    if (full.existencia > 0)
                        return '<a href="javascript:Agregar(' + full.id_producto + ',' + meta.row + "," + "&#39;" + encodeURI(full.envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.precio) + "&#39;" + "," + full.existencia + ');" class="btn btn-primary btn-md" style="display:' + '" title="Agregar"><span class="glyphicon glyphicon-plus"></span></a>';
                    else
                        return "";
                }
            }
        ],
        // language: {
        //     sProcessing: "Procesando...",
        //     sLoadingRecords: "Cargando...",
        //     sInfoFiltered: "(filtrando un total de _MAX_ registros)",
        //     lengthMenu: "Se muestran _MENU_ registros por página",
        //     sZeroRecords: "No se encontraron resultados",
        //     sEmptyTable: "Ningún dato disponible en esta tabla",
        //     info: "Mostrando página _PAGE_ de _PAGES_",
        //     infoEmpty: "No hay registros disponibles",
        //     search: "Búsqueda",
        //     paginate: {
        //         sFirst: "Primero",
        //         sLast: "Último",
        //         previous: "Anterior",
        //         next: "Siguiente"
        //     },
        //     infoFiltered: "(filtered from _MAX_ total records)"
        // }
    });
}



function AlmacenarCliente() {

    var nit = $("#txtNit").val().trim();
    var nombre = $("#txtNombre").val().trim();
    var telefono = $("#txtTelefono").val().trim();
    var email = $("#txtEmail").val().trim();
    var direccion = $("#txtDireccion").val().trim();
    var error = "";

    if (nit == "") {
        MensajeError("input tax id");
        return;
    }

    if (nombre == "") {
        MensajeError("input name");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/cliente",
        data: {
            nit: nit,
            nombre: nombre,
            direccion: direccion,
            telefono: telefono,
            email: email
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    clientes = [];
    availableTags = [];
    CargarClientes();
    $("#txtNitBuscar").val("");

    MensajeExitoso("record saved");
    $('#nuevoCliente').modal('hide');
}


function AlmacenarProducto() {

    var nombre = $("#txtProducto").val().trim();
    var envase = $("#ddlEnvase").val();
    var costo = $("#txtCosto").val().trim();
    var precio = $("#txtPrecio").val().trim();
    var existencia = $("#txtExistencia").val().trim();
    var catalogo = $("#ddlCatalogo").val();
    var error = "";

    if (nombre == "") {
        MensajeError("input name");
        return;
    }

    if (envase == 0) {
        MensajeError("input container");
        return;
    }

    if (costo == "") {
        MensajeError("input cost");
        return;
    }

    if (isNaN(costo)) {
        MensajeError("input numeric value in cost");
        return;
    }

    if (precio == "") {
        MensajeError("input price");
        return;
    }

    if (isNaN(precio)) {
        MensajeError("input numeric value in price");
        return;
    }

    if (parseFloat(precio) < parseFloat(costo)) {
        MensajeError("the price cannot be lower than the cost");
        return;
    }

    if (existencia == "") {
        MensajeError("input stock");
        return;
    }

    if (isNaN(existencia)) {
        MensajeError("input umeric value in stock");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/producto",
        data: {
            nombre: nombre,
            envase: envase,
            costo: costo,
            precio: precio,
            existencia: existencia,
            catalogo: catalogo
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    MensajeExitoso("record saved");

    CargarProductos();
    $('#nuevoProducto').modal('hide');
}


function alertTimeout(mymsg, mymsecs) {
    var myelement = document.createElement("div");
    myelement.setAttribute("style", "background-color: grey;color:black; width: 450px;height: 200px;position: absolute;top:0;bottom:0;left:0;right:0;margin:auto;border: 4px solid black;font-family:arial;font-size:25px;font-weight:bold;display: flex; align-items: center; justify-content: center; text-align: center;");
    myelement.innerHTML = mymsg;
    setTimeout(function () {
        myelement.parentNode.removeChild(myelement);
    }, mymsecs);
    document.body.appendChild(myelement);
}


function AgregarProductoBarra() {

    var id = $("#txtProductoBuscar").val().trim() == "" ? 0 : parseInt($("#txtProductoBuscar").val());

    if (id == 0) {
        console.log("nada");
        return;
    }

    var contador = 0;
    for (var key in productos) {

        var dto = productos[key];

        if (dto.id_producto == id) {

            if(dto.existencia == 0){
                MensajeError("the product is out of stock");
                break;
            }

            var index = detalles.length;
            var cantidad = 1;
            var descripcion = dto.envase + " " + dto.nombre;
            var sinFormato = dto.precio.replace(",", "");
            var precio = parseFloat(dto.precio).toFixed(2);
            var subtotal = (cantidad * sinFormato).toFixed(2);
            var total = $("#hfTotal").val() == "" ? 0 : parseFloat($("#hfTotal").val());
            var nuevo = parseFloat(subtotal);
            total += nuevo;
            productos[key].existencia = productos[key].existencia - 1;
            //console.log(productos[key].existencia);

            var dto = { index: index, id: id, cantidad: cantidad, descripcion: descripcion, precio: precio, subtotal: Formatear(subtotal) };
            detalles.push(dto);
            CargarTabla(detalles);

            $("#hfTotal").val(total);
            var letras = Number.isInteger(total) ? total.toLocaleString("en-US") + ".00" : total.toLocaleString("en-US");
            $("#spTotal").text("TOTAL: " + letras);
            contador++;
        }
    }
    
    CargarTablaProductos(productos);
    $("#txtProductoBuscar").val('');
}




function Agregar(id, roxIndex, envase, producto, precio, existencia) {

    var combo = "#Markup_" + roxIndex;
    var valor = $(combo).val().trim();

    if (valor == "") {
        MensajeError("input quantity");
        return;
    }

    if (isNaN(valor)) {
        MensajeError("input numeric value in quantity");
        return;
    }

    if (valor == 0) {
        MensajeError("quantity cannot be zero");
        return;
    }

    if (valor > existencia) {
        MensajeError("the quantity cannot exceed the available stock");
        return;
    }

    var sinFormato = precio.replace(",", "");
    var unitario = parseFloat(sinFormato).toFixed(2);
    var index = detalles.length;
    var cantidad = parseInt(valor);
    var descripcion = decodeURI(envase) + " " + decodeURI(producto);
    var subtotal = (cantidad * sinFormato).toFixed(2);
    var total = $("#hfTotal").val() == "" ? 0 : parseFloat($("#hfTotal").val());
    var nuevo = parseFloat(subtotal);
    total += nuevo;

    var dto = { index: index, id: id, cantidad: cantidad, descripcion: descripcion, precio: unitario, subtotal: subtotal };
    detalles.push(dto);
    CargarTabla(detalles);

    $("#hfTotal").val(total);
    $("#spTotal").text("TOTAL: " + Formatear(total));

    //let number = parseFloat(4787.02);
    //var jj = number.toLocaleString("en-US");

    for (var i = 0; i < productos.length; i++) {
        var pas = productos[i];

        if (id == pas.id_producto) {
            pas.existencia = pas.existencia - cantidad;
            //console.log(pas);
            break;
        }
    }


    CargarTablaProductos(productos);
}


function Formatear(valor) {
    var total = parseFloat(valor);
    return Number.isInteger(total) ? total.toLocaleString("en-US") + ".00" : total.toLocaleString("en-US");
}


function Borrar(index) {

    for (var i = 0; i < detalles.length; i++) {

        var dto = detalles[i];

        if (dto.index == index) {
            detalles.splice(i, 1);

            var subtotal = parseFloat(dto.subtotal);
            var total = $("#hfTotal").val() == "" ? 0 : parseFloat($("#hfTotal").val());
            var nuevo = parseFloat(subtotal);
            total -= nuevo;

            $("#hfTotal").val(total);
            var letras = Number.isInteger(total) ? total.toLocaleString("en-US") + ".00" : total.toLocaleString("en-US");
            $("#spTotal").text("TOTAL: " + letras);

            for (var j = 0; j < productos.length; j++) {
                var pas = productos[j];

                var agotado = agotados.indexOf(dto.id) > -1 ? true : false;

                if (dto.id == pas.id_producto && !agotado) {
                    pas.existencia = pas.existencia + dto.cantidad;
                    //console.log(pas);
                    CargarTablaProductos(productos);
                    break;
                }
            }
        }
    }

    for (var i = 0; i < detalles.length; i++) {
        var dto = detalles[i];
        dto.index = i;
    }


    if (detalles.length > 0)
        CargarTabla(detalles);
    else
        Limpiar();

    $("#txtProductoBuscar").focus();
    
}


function AlmacenarFactura() {

    var error = "";
    var idCliente = $("#hfIdCliente").val();
    var total = $("#hfTotal").val();
    var tipo = $("#txtNitBuscar").val().trim() == "C/F" ? 1 : 2;

    if (idCliente == "") {
        MensajeError("input tax id");
        return;
    }

    if (detalles.length == 0) {
        MensajeError("input product");
        return;
    }

    $.ajax({
        async: true,
        type: "POST",
        url: "/factura",
        data: {
            idCliente: idCliente,
            detalles: detalles,
            total: total,
            tipo: tipo
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
            $("#hfId").val(result.id);
            agotados = result.agotados;

            if (error != "") {
                MensajeError(error);
                return;
            }

            ActualizarAgotados();

            $("#btnAlmacenarFactura").prop('disabled', true);
        
            MensajeExitoso("record created succesfully");

        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

}

function ActualizarAgotados() {

    if (agotados.length == 0)
        return;

    var array = agotados.split(',');

    for (var j = 0; j < array.length; j++) {
        var id = array[j];

        for (var i = 0; i < productos.length; i++) {
            var pas = productos[i];
    
            if (id == pas.id_producto) {
                pas.existencia = 0;
                //console.log(pas);
                break;
            }
        }
    }

    CargarTablaProductos(productos);
}

function Imprimir() {

    var id = $("#hfId").val() == "" ? 0 : parseInt($("#hfId").val());

    if (id == 0) {
        MensajeError("Must exists an envoice saved");
        return;
    }

    var error = "";
    var base64 = "";
    var nombre = "";

    $.ajax({
        async: true,
        type: "POST",
        url: "/factura/download",
        data: {
            id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
            base64 = result.base64;
            nombre = result.nombre;
            console.log(base64);

            if (error != "") {
                MensajeError(error);
                return;
            }
        
            printJS({ printable: base64, type: 'pdf', base64: true });
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    
}
