$(document).ready(function () {
    Cargar();

    document.addEventListener('keydown', function (event) {
        if (event.keyCode == 74 && event.ctrlKey) {
            event.preventDefault();
        }
    });

    $("#btnEliminar").click(function (e) {
        Anular();
        return true;
    });

});


function Cargar() {

    var data = [];
    var perfil = 0;
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/factura",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
            perfil = result.perfil;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });

    var item = perfil < 3 ? "Bfrtip" : "frtip";
    CargarTabla(data, item);
}


function CargarTabla(dataSet, dom) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: false,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_factura" },
            { mData: "nit" },
            { mData: "nombre" },
            { mData: "fecha" },
            { mData: "total", "className": "text-right" },
            { mData: "estatus" },
            //{ mData: "confirmacion" },
            { mData: "usuario" },
        ],
        /*
        createdRow: function( row, data, dataIndex){

            if( data.id_cliente == 1 ){
                $(row).css('background-color', '#e1f9dc'); //9EF395 A497E5  F39B9B
            }
            else if( data.id_cliente > 1 && data.id_cliente <= 2  ){
                $(row).css('background-color', '#A497E5');
            }
            else{
                $(row).css('background-color', '#f9dce0');
            }
        },
        */
        aoColumnDefs: [
            {
                "aTargets": [7],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Descargar(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Download"><span class="glyphicon glyphicon-save"></span></a>';
                    else
                        return '';
                }
            },
            {
                "aTargets": [8],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Imprimir(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Print"><span class="glyphicon glyphicon-print"></span></a>';
                    else
                        return '';
                }
            },
            {
                "aTargets": [9],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "5%",
                "className": "text-center",
                "mRender": function (data, type, full, meta) {
                    if (full.estado == "1")
                        return '<a href="javascript:Cambiar(' + "&#39;" + encodeURI(full.id_factura) + "&#39;" + "," + "&#39;" + encodeURI(full.nit) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + "," + "&#39;" + encodeURI(full.fecha) + "&#39;" + "," + "&#39;" + encodeURI(full.total) + "&#39;" + "," + full.estado + ');" class="btn btn-danger btn-md" style="display:' + '" title="Cancel"><span class="glyphicon glyphicon-remove"></span></a>';
                    else
                        return '';
                }
            }
        ],
        // language: {
        //     sProcessing: "Procesando...",
        //     sLoadingRecords: "Cargando...",
        //     sInfoFiltered: "(filtrando un total de _MAX_ registros)",
        //     lengthMenu: "Se muestran _MENU_ registros por página",
        //     sZeroRecords: "No se encontraron resultados",
        //     sEmptyTable: "Ningún dato disponible en esta tabla",
        //     info: "Mostrando página _PAGE_ de _PAGES_",
        //     infoEmpty: "No hay registros disponibles",
        //     search: "Búsqueda",
        //     paginate: {
        //         sFirst: "Primero",
        //         sLast: "Último",
        //         previous: "Anterior",
        //         next: "Siguiente"
        //     },
        //     infoFiltered: "(filtered from _MAX_ total records)"
        // },
        dom: dom,
        buttons:
            [
                'pdfHtml5',
                'excelHtml5'
                /*
                'print',
                'copyHtml5',
                'csvHtml5'
                */
            ]
    });

    /*
    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
    */
}


async function Descargar(id) {

    try {
        $("#divLoading").show();

        var parametros = { id: id };
        var info = await postProcess("/factura/download", parametros);

        if (info.error != "") {
            MensajeError(info.error);
            return;
        }

        await DescargarPDF(info.html, info.nombre);
        //DescargarArchivo(info.base64, info.nombre, "application/octet-stream");

    } catch (err) {
        MensajeError(err.message);
    } finally {
        $("#divLoading").hide();
    }
}


function DescargarArchivo(base64, nombre, mime) {

    var ua = window.navigator.userAgent;
    var msie = ua.indexOf('MSIE ');
    var trident = ua.indexOf('Trident/');
    var edge = ua.indexOf('Edge/');
    var esIE = false;

    var binary_string = window.atob(base64);
    //var binary_string = window.atob(str64);
    var len = binary_string.length;
    var bytes = new Uint8Array(len);
    for (var i = 0; i < len; i++) {
        bytes[i] = binary_string.charCodeAt(i);
    }

    var nuevoArray = bytes.buffer;
    var blob = new Blob([nuevoArray], { type: mime });

    if (msie > 0 || trident > 0 || edge > 0) {
        window.navigator.msSaveOrOpenBlob(blob, nombre);
        return;
    }

    var a = document.createElement("a");
    document.body.appendChild(a);
    a.style = "display: block";

    url = window.URL.createObjectURL(blob);
    a.href = url;
    a.download = nombre;
    a.click();
    window.URL.revokeObjectURL(url);
}


async function Imprimir(id) {

    try {

        $("#divLoading").show();

        var parametros = { id: id };
        var info = await postProcess("/factura/download", parametros);

        if (info.error != "") {
            MensajeError(info.error);
            return;
        }

        await GenerarYMostrarPDF(info.html, info.nombre);

    } catch (err) {
        MensajeError(err.message);
    } finally {
        $("#divLoading").hide();
    }
}


async function GenerarYMostrarPDF(html, nombre) {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF({ format: 'letter' });

    await doc.html(html, {
        callback: function (doc) {
            // Convertir el PDF a un Blob
            const pdfBlob = doc.output('blob');

            // Crear un URL para el Blob
            const pdfUrl = URL.createObjectURL(pdfBlob);

            // Crear un iframe oculto
            const iframe = document.createElement('iframe');
            iframe.style.position = 'fixed';
            iframe.style.width = '0';
            iframe.style.height = '0';
            iframe.style.border = 'none';
            iframe.src = pdfUrl;

            // Agregar el iframe al DOM
            document.body.appendChild(iframe);

            // Esperar a que el iframe cargue el PDF y luego imprimir
            iframe.onload = function () {
                iframe.contentWindow.print();

                // Después de la impresión, remover el iframe y liberar el Blob URL
                iframe.addEventListener('afterprint', function () {
                    document.body.removeChild(iframe);
                    URL.revokeObjectURL(pdfUrl);
                });

                typeof InstallTrigger !== 'undefined' ? console.clear() : "";
            };
        },
        x: 10,
        y: 10,
        html2canvas: { scale: 0.17 }
    });
}

//abre pdf en otra pestaña
async function GenerarYMostrarPDF1(html) {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF({ format: 'letter' });

    await doc.html(html, {
        callback: function (doc) {
            // Convertir el PDF a un Blob
            const pdfBlob = doc.output('blob');

            // Crear un URL para el blob
            const pdfUrl = URL.createObjectURL(pdfBlob);

            // Abrir el PDF en una nueva pestaña
            window.open(pdfUrl, '_blank');

            // Opcional: liberar el Blob URL después de su uso
            URL.revokeObjectURL(pdfUrl);
        },
        x: 10,
        y: 10,
        html2canvas: { scale: 0.17 }
    });
}


function Cambiar(id, nit, nombre, fecha, total, index) {

    var html = `¿Are you sure to cancel this invoice with that info: ?
                <br/>
                <br/>
                <table class="table table-striped">
                <thead>
                </thead>
                <tbody>
                <tr>
                <td>ENVOICE</td>
                <td>${decodeURI(id)}</td>
                </tr>
                <tr>
                <td>TAX ID </td>
                <td>${decodeURI(nit)}</td>
                </tr>
                <tr>
                <td>NAME </td>
                <td>${decodeURI(nombre)}</td>
                </tr>
                <tr>
                <td>DATE </td>
                <td>${decodeURI(fecha)}</td>
                </tr>
                <tr>
                <td>TOTAL </td>
                <td>${decodeURI(total)}</td>
                </tr>
                </tbody>
                </table>
                `;

    $("#hfId").val(decodeURI(id));
    $("#hfIndex").val(index);

    $("#spTextoBorrar").html(html);
    $('#modalBorrar').modal('show');
}


async function Anular() {

    var id = $("#hfId").val();

    try {

        $("#divLoading").show();

        var parametros = { id: id };
        var info = await postProcess("/factura/cancel", parametros);

        if (info.error != "") {
            MensajeError(info.error);
            return;
        }

        Cargar();

        MensajeExitoso("Factura anulada exitosamente");
        $('#modalBorrar').modal('hide');

    } catch (err) {
        MensajeError(err.message);
    } finally {
        $("#divLoading").hide();
    }
}


async function DescargarPDF(html, nombre) {

    const { jsPDF } = window.jspdf;
    const doc = new jsPDF({ format: 'letter' });

    await doc.html(html, {
        callback: function (doc) {
            doc.save(nombre);
        },
        x: 10,
        y: 10,
        html2canvas: { scale: 0.17 }
    });

    typeof InstallTrigger !== 'undefined' ? console.clear() : "";
}
