$(document).ready(function () {
    Cargar();

    $("#btnNuevo").click(function (e) {
        MostrarNuevo();
        return true;
    });

    $("#btnAlmacenar").click(function (e) {
        Almacenar();
        return true;
    });

    $("#btnEliminar").click(function (e) {
        Eliminar();
        return true;
    });

    document.addEventListener('keydown', function (event) {
        if(event.keyCode == 74 && event.ctrlKey){
            event.preventDefault();
        }
    });

});

function MostrarVentana(texto) {

    $("#spTexto").text(texto);
    $('#myModal').modal('show');
}

function Cargar() {

    var data = [];
    var error = "";

    $.ajax({
        async: false,
        type: "GET",
        url: "/envase",
        data: {
        },
        success: function (result) {
            data = result.mensaje;
        },
        error: function (errMsg) {
            MostrarVentana(errMsg.responseText);
        }
    });


    CargarTabla(data);
}


function CargarTabla(dataSet) {
    var t = $('#tbRegistros').DataTable({
        data: dataSet,
        pageLength: 5,
        bLengthChange: false,
        ordering: true,
        destroy: true,
        bPaginate: true,
        bFilter: true,
        //bServerSide: false,
        searching: true,
        autoWidth: false,
        info: true,
        aoColumns: [
            { mData: "id_envase" },
            { mData: "nombre" },
        ],
        aoColumnDefs: [
            {
                "aTargets": [2],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Editar(' + "&#39;" + encodeURI(full.id_envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-info btn-md" style="display:' + '" title="Edit"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            },
            {
                "aTargets": [3],
                "mData": "",
                "bSearchable": false,
                "bSortable": false,
                "Width": "30px",
                "mRender": function (data, type, full, meta) {
                    return '<a href="javascript:Borrar(' + "&#39;" + encodeURI(full.id_envase) + "&#39;" + "," + "&#39;" + encodeURI(full.nombre) + "&#39;" + ');" class="btn btn-primary btn-md" style="display:' + '" title="Delete"><span class="glyphicon glyphicon-edit"></span></a>';
                }
            }

        ],
        // language: {
        //     sProcessing: "Procesando...",
        //     sLoadingRecords: "Cargando...",
        //     sInfoFiltered: "(filtrando un total de _MAX_ registros)",
        //     lengthMenu: "Se muestran _MENU_ registros por página",
        //     sZeroRecords: "No se encontraron resultados",
        //     sEmptyTable: "Ningún dato disponible en esta tabla",
        //     info: "Mostrando página _PAGE_ de _PAGES_",
        //     infoEmpty: "No hay registros disponibles",
        //     search: "Búsqueda",
        //     paginate: {
        //         sFirst: "Primero",
        //         sLast: "Último",
        //         previous: "Anterior",
        //         next: "Siguiente"
        //     },
        //     infoFiltered: "(filtered from _MAX_ total records)"
        // }
    });

    t.on('order.dt search.dt', function () {
        t.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
}



function MostrarNuevo(){

    $("#hfId").val("");
    $("#txtNit").val("");
    $("#txtNombre").val("");
    $("#txtTelefono").val("");
    $("#txtEmail").val("");
    $("#txtDireccion").val("");

    $("#spTitulo").text("New Container");
    $('#nuevoCliente').modal('show');   
}



function Almacenar() {
    
    var id = $("#hfId").val() == "" ? 0 :  $("#hfId").val();

    if (id > 0)
        Actualizar();
    else
        Insertar();
}


function Insertar() {
    
    var nombre = $("#txtNombre").val().trim();
    var error = "";
    
    if (nombre == "") {
        MensajeError("input name");
        return;
    }

    $.ajax({
        async: false,
        type: "POST",
        url: "/envase",
        data: {
            nombre: nombre
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record saved");
    $('#nuevoCliente').modal('hide');
}


function Editar(id, nombre){

    $("#hfId").val(id);
    $("#txtNombre").val(decodeURI(nombre));
    
    $("#spTitulo").text("Edit container " + decodeURI(nombre));
    $('#nuevoCliente').modal('show');
}


function Actualizar(){

    var id = $("#hfId").val();
    var nombre = $("#txtNombre").val().trim();
    var error = "";
    
    if (nombre == "") {
        MensajeError("input name");
        return;
    }

    $.ajax({
        async: false,
        type: "PUT",
        url: "/envase",
        data: {
            id: id,
            nombre: nombre
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record saved");
    $('#nuevoCliente').modal('hide');
}


function Borrar(id, nombre){

    $("#hfId").val(decodeURI(id));
    $("#spTextoBorrar").html("Are you sure to delete record from " + decodeURI(nombre) + "?");
    $('#modalBorrar').modal('show');
}


function Eliminar(){

    var id = $("#hfId").val();

    $.ajax({
        async: false,
        type: "DELETE",
        url: "/envase",
        data: {
           id: id
        },
        beforeSend: function () {
            $("#divLoading").show();
        },
        success: function (result) {
            error = result.error;
        },
        error: function (errMsg) {
            MensajeError(errMsg.responseText);
        },
        complete: function () {
            $("#divLoading").hide();
        }
    });

    if (error != "") {
        MensajeError(error);
        return;
    }

    Cargar();

    MensajeExitoso("record deleted");
    $('#modalBorrar').modal('hide');
}
