module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("producto", {
        id_producto: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        nombre: { type: Sequelize.STRING, max: 100 },
        id_envase: { type: Sequelize.INTEGER, references: { model: 'envase', key: 'id_envase', } },
        costo: { type: Sequelize.DECIMAL(10,2) },
        precio: { type: Sequelize.DECIMAL(10,2) },
        inicial: { type: Sequelize.INTEGER },
        existencia: { type: Sequelize.INTEGER },
        catalogo: { type: Sequelize.INTEGER },
        ubicacion: { type: Sequelize.STRING, max: 100 },
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'producto'
    });

    return modelo;
};