module.exports = (sequelize, Sequelize) => {

    const modelo = sequelize.define("detalle", {
        id_detalle: { type: Sequelize.INTEGER, primaryKey: true, autoIncrement: true },
        id_factura: { type: Sequelize.INTEGER,  references: { model: 'factura', key: 'id_factura', } },
        id_producto: { type: Sequelize.INTEGER, references: { model: 'producto', key: 'id_producto', } },
        cantidad: { type: Sequelize.INTEGER },
        precio: { type: Sequelize.DECIMAL(10,2) },
        sub_total: { type: Sequelize.DECIMAL(10,2) },
        estado: { type: Sequelize.INTEGER },
    }, {
        timestamps: true,
        paranoid: false,
        freezeTableName: false,
        tableName: 'detalle'
    });

    return modelo;
};