const express = require('express');
//const hbs = require('express-handlebars');
const session = require('express-session');
const cookieParser = require('cookie-parser');
//const path = require('path');
var ejs = require('ejs');
var cors = require('cors');

const app = express();
app.use(cors());

var Usuario = require('./controllers/usuario.js');

//app.use(express.json());

// Aumenta el límite de tamaño del cuerpo
app.use(express.json({ limit: '50mb' }));
app.use(express.urlencoded({ limit: '50mb', extended: true }));
// app.use(express.json());
// app.use(express.urlencoded({ extended: true }));


/*
app.engine('hbs', hbs({
    defaultLayout: 'main',
    extname: '.hbs'
}));

app.set('view engine', 'hbs');
*/

app.use(express.static('public'));
app.set('view engine', 'html');

/*
app.engine('html', require('ejs').renderFile);
app.set('view engine', 'html');
app.set('views', __dirname );
*/

app.use(cookieParser());

/*
var expiryDate = new Date( Date.now() + 60 * 60 * 1000 ); // 1 hour
app.use(session({
  name: 'session',
  keys: ['key1', 'key2'],
  cookie: { secure: true,
            httpOnly: true,
            domain: 'localhost',
            path: 'foo/bar',
            expires: expiryDate
          }
  })
);
*/


app.use(session({
    secret: '34SDgsdgspxxxxxxxdfsG',
    resave: false,
    saveUninitialized: true
    //cookie: { httpOnly: true, secure: true } 
}));

const empresa = "Company";
const db = require('./models/index.js');
db.sequelize.sync({ force: false });

var userRouter = require('./routes/usuario.js')
var clienteRouter = require('./routes/cliente.js');
var envaseRouter = require('./routes/envase.js');
var productoRouter = require('./routes/producto.js');
var perfilRouter = require('./routes/perfil.js');
var facturaRouter = require('./routes/factura.js');
var qrRputer = require('./routes/qr.js');
var compraRouter = require('./routes/compra.js');
var catalogoRouter = require('./routes/catalogo.js');
var catalogoProductoRouter = require('./routes/catalogo_producto.js');
var contadorRouter = require('./routes/contador.js');

app.use('/cliente', requireLogin, clienteRouter);
app.use('/usuario', requireLogin, userRouter);
app.use('/metal', userRouter);
app.use('/cliente', requireLogin, clienteRouter);
app.use('/envase', requireLogin, envaseRouter);
app.use('/producto', requireLogin, productoRouter);
app.use('/perfil', requireLogin, perfilRouter);
app.use('/factura', requireLogin, facturaRouter);
app.use('/compra', requireLogin, compraRouter);
app.use('/catalogo', requireLogin, catalogoRouter);
app.use('/catalogo-producto', requireLogin, catalogoProductoRouter);
app.use('/contador', requireLogin, contadorRouter);
app.use('/qr', qrRputer);

app.get('/', async function (req, res) {
    var html = await ejs.renderFile(__dirname + '/public/_index.html', { empresa: empresa }, { async: true });
    res.send(html);
    //res.send('index');
    //res.send('index.html');
    //req.session.cuenta = req.session.cuenta ? req.session.cuenta + 1 : 1;
});


app.get('/logout', function (req, res) {
    req.session.destroy();
    res.redirect('/');
});


app.post('/login', async function (req, res) {
    if (!req.body.usuario) return res.send({ error: "input user" });
    if (!req.body.clave) return res.send({ error: "input password" });

    var error = "";
    var perfil = 0;

    try {

        var result = await Usuario.validate(req.body.usuario, req.body.clave);

        if (result.error != "")
            error = result.error;
        else {
            req.session.loggedIn = true;
            req.session.usuario = req.body.usuario.toUpperCase();
            req.session.id = result.id;
            req.session.id_usuario = result.id;
            req.session.perfil = result.perfil;
            perfil = result.perfil;
        }
    }
    catch (err) {
        error = err.message;
    }

    return res.send({ error: error, perfil: perfil });
});

app.get('/facturas', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_facturas.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_facturas.html');;
});

app.get('/nueva', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_nueva_factura.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_nueva_factura.html');;
});

app.get('/clientes', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_clientes.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_clientes.html');
});

app.get('/usuarios', requireLogin, async function (req, res) {
    if (req.session.perfil != 1) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_usuarios.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_usuarios.html');
});

app.get('/productos', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_productos.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_productos.html');
});

app.get('/envases', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_envases.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_envases.html');
});

app.get('/catalogos', requireLogin, async function (req, res) {
    if (req.session.perfil == 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_catalogos.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_envases.html');
});

app.get('/perfiles', requireLogin, async function (req, res) {
    if (req.session.perfil != 1) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_perfil.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_perfil.html', info);
});


app.get('/contadores', requireLogin, async function (req, res) {
    if (req.session.perfil != 4) return res.redirect("/");
    var html = await ejs.renderFile(__dirname + '/public/_contador.html', { perfil: req.session.perfil, usuario: req.session.usuario, empresa: empresa }, { async: true });
    return res.send(html);
    //res.sendFile(__dirname + '/public/_perfil.html', info);
});

app.get('/barcode', async (req, res) => {

    const axios = require('axios');
    const texto = req.query.data ?? "0000";
    const url = `https://barcode.tec-it.com/barcode.ashx?data=${texto}&code=Code39&multiplebarcodes=true&translate-esc=false&unit=Fit&dpi=96&imagetype=Gif&rotation=0&color=%23000000&bgcolor=%23ffffff&codepage=Default&qunit=Mm&quiet=0`;

    try {
        const response = await axios.get(url, { responseType: 'arraybuffer' });
        res.set('Content-Type', 'image/gif');
        return res.send(response.data);

    } catch (error) {
        return res.status(500).send({ error: error.message });
    }

});

app.get('/proxy', async (req, res) => {

    const axios = require('axios');
    const texto = req.query.data ?? "0000";
    const url = `https://barcode.tec-it.com/barcode.ashx?data=${texto}&code=Code39&multiplebarcodes=true&translate-esc=false&unit=Fit&dpi=96&imagetype=Gif&rotation=0&color=%23000000&bgcolor=%23ffffff&codepage=Default&qunit=Mm&quiet=0`;

    try {
        const response = await axios.get(url, { responseType: 'arraybuffer' });
        const base64Image = Buffer.from(response.data, 'binary').toString('base64');
        const base64 = `data:image/gif;base64,${base64Image}`;
        return res.send(base64);
    } catch (error) {
        // Manejar errores si la solicitud falla
        return res.status(500).send({ error: error.message });
    }

});


app.post('/pdf', async (req, res) => {

    const axios = require('axios');
    const fs = require('fs').promises; 
    const path = require('path');

    try {
        const texto = req.body.html || "";

        if (texto === "")
            return res.status(400).json({ error: "Ingrese HTML" });

        const apiUrl = 'http://192.3.245.177/html-pdf/pdf';
        const info = { html: texto };

        const response = await axios.post(apiUrl, info);
        const data = response.data;

        if (data.error != "" || data.base64 == "")
            return res.status(400).json({ error: "Error al generar PDF: " + data.error });

        const nombre = req.body.nombre ?? "generated.pdf";
        const tempFilePath = path.join(__dirname, './tmp/', nombre);
        // Escribe el archivo temporal
        await fs.writeFile(tempFilePath, data.base64, 'base64');

        // Establecer los encabezados de la respuesta para la descarga del archivo PDF
        res.setHeader('Content-Type', 'application/pdf');
        res.setHeader('Content-Disposition', 'attachment; filename="generated.pdf"');

        // Enviar el archivo PDF como descarga
        res.download(tempFilePath, nombre, async (err) => {
            if (err) {
                console.error('Error al enviar el archivo:', err);
            }

            // Elimina el archivo temporal después de enviarlo
            try {
                await fs.unlink(tempFilePath);
            } catch (unlinkError) {
                console.error('Error al eliminar el archivo temporal:', unlinkError);
            }
        });

        //return res.send({error: data.error, base64: data.base64});

        // console.log(data.base64);

        // const pdfBuffer = await Buffer.from(data.base64, 'base64');
        // console.log(pdfBuffer);

        // // Establecer encabezados para la descarga del archivo PDF
        // res.setHeader('Content-Type', 'application/pdf');
        // res.setHeader('Content-Disposition', 'attachment; filename="generated.pdf"');

        // // Enviar el archivo PDF como descarga
        // return res.send(pdfBuffer);

    } catch (error) {
        console.error("Error al procesar la solicitud:", error);
        return res.status(500).json({ error: error.message });
    }
});



/*
app.get('/qrcode', (req, res) => {

    var qr = require('qr-image');

    
    //router.get('/', function(req, res) {
        var code = qr.image("text to show in qr", { type: 'png', ec_level: 'H', size: 10, margin: 0 });

        console.log(code);

        res.type('png');
        code.pipe(res);
        // res.render('index', { title: 'QR Page', qr: code });
    //});
    

    /*
    const url  = 'https://www.diogocezar.com';
    const code = qr.image(url, {type : 'svg', size: 10});
    res.type('svg');
    code.pipe(res);
    */

// });


/*
app.get('/qr', function (req, res) {

    console.log(req.query.id);
    //console.log(req.query.co);

    res.send({id: + req.query.id, co: req.query.co});

    //res.sendFile(__dirname + '/public/_perfil.html');
});
*/


const PORT = process.env.PORT || 4000;

app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}.`);
});


function requireLogin(req, res, next) {
    if (req.session.loggedIn) {
        next(); // allow the next route to run
    } else {
        // require the user to log in
        return res.redirect("/"); // or render a form, etc.
    }
}