const db = require("../models");
const model = db.catalogo_producto;
const Op = db.Sequelize.Op;


exports.get = async function (req, res) {

    var query = `select @rownum:=@rownum+1 as numero, a.id_producto as id, c.nombre as envase, b.nombre as nombre
                from (select @rownum:= 0) r, catalogo_producto a
                inner join producto b on b.id_producto = a.id_producto
                inner join envase c on c.id_envase = b.id_envase `;

    const id = req.query.id;

    if (id) query += ` where a.id_catalogo = '${id}'  `;

    await db.sequelize.query(query, { type: db.sequelize.QueryTypes.SELECT })
        .then(data => {
            return res.send({ mensaje: data, perfil: req.session.perfil, error: "" });
        }).catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });
}

exports.findById = async function (req, res) {

    let id = req.params.id;
    await model.findAll({
        where: { id: id }
    })
};

exports.post = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });
    if (isNaN(req.body.id)) return res.send({ error: "ingrese valor numúmerico en id" + req.body.id });

    var j = 0;
    var error = "";
    var id = req.body.id;
    var productos = req.body.productos;
    const t = await db.sequelize.transaction();

    try {

        var query = `delete from catalogo_producto where id_catalogo = ${id} `;
        await db.sequelize.query(query, { type: db.sequelize.QueryTypes.delete }, { transaction: t });

        for (var key in productos) {
            var dto = productos[key];

            await model.create({
                id_catalogo: id,
                id_producto: dto.id,
                id_usuario: req.session.id_usuario
            }, { transaction: t });

            j++;
        }

        await t.commit();

    } catch (err) {
        error = err.message;
        console.log(error);
        await t.rollback();
    }

    if (j > 0)
        return res.send({ mensaje: "exitosa", error: "" });
    else
        return res.send({ mensaje: "fallida", error: error });

};


exports.put = async function (req, res) {

    if (!req.body.nombre) return res.send({ error: "ingrese nombre" });
    if (!req.body.id) return res.send({ error: "ingrese id" });


    var id = req.body.id;
    var nombre = req.body.nombre.toUpperCase();
    var condition = nombre ? { nombre: { [Op.like]: `%${nombre}%` }, id_envase: { [Op.not]: id } } : null;

    var registros = await model.findAll({ where: condition })
        .then(data => {
            return data.length;
        })
        .catch(err => {
            res.status(500).send({ message: err.message || "Some error occurred while retrieving tutorials." });
        });

    if (registros > 0)
        return res.send({ error: "ya existe envase con ese nombre" });

    await model.update(
        {
            nombre: nombre
        },
        {
            where: { id_envase: id }
        }
    )
        .then(data => {
            res.send({ mensaje: "Registro actualizado exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};


exports.delete = async function (req, res) {

    if (!req.body.id) return res.send({ error: "ingrese id" });

    let id = req.body.id;
    await model.destroy({
        where: { id_envase: id }
    })
        .then(data => {
            res.status(200).send({ mensaje: "Registro elimiando exitosamente", error: "" });
        })
        .catch(err => {
            res.send(err);
        })
};